/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.connection;

import datamaxoneil.Monitor;
import datamaxoneil.connection.ConnectionBase;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class Connection_UDP
extends ConnectionBase {
    private ServerSocket m_UdpListener = null;
    private Socket m_UdpClient = null;
    private DataInputStream m_StreamRead = null;
    private DataOutputStream m_StreamWrite = null;
    private String m_Address = "127.0.0.1";
    private int m_Port = 515;

    public String getRemoteEnd() {
        return this.m_UdpClient == null ? "-none-" : this.m_UdpClient.getRemoteSocketAddress().toString();
    }

    protected Connection_UDP(boolean isServer, String targetDevice, int port) {
        super(isServer);
        this.m_Port = port;
        this.m_Address = targetDevice;
    }

    public static Connection_UDP createClient(String targetDevice, int port) {
        return new Connection_UDP(false, targetDevice, port);
    }

    public static Connection_UDP createServer(int port) {
        return new Connection_UDP(true, "", port);
    }

    @Override
    protected boolean getHasData() {
        boolean hasData = false;
        try {
            hasData = this.m_StreamRead.available() > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hasData;
    }

    @Override
    protected boolean innerOpen() throws IOException {
        if (this.getIsServerMode()) {
            if (!this.m_Reconnecting) {
                this.m_UdpListener = new ServerSocket(this.m_Port);
            }
            this.m_IsOpen = true;
        } else {
            this.m_UdpClient = new Socket(this.m_Address, this.m_Port, false);
            this.m_StreamRead = new DataInputStream(this.m_UdpClient.getInputStream());
            this.m_StreamWrite = new DataOutputStream(this.m_UdpClient.getOutputStream());
            this.m_IsActive = this.m_IsOpen = this.m_StreamRead != null && this.m_StreamWrite != null;
        }
        return this.m_IsOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void close(boolean isInternalCall) {
        v0 = timeout = isInternalCall != false ? 0 : 0x7FFFFFFF;
        do {
            if (Monitor.tryEnter(this.m_LockGeneral, 0L)) {
                try {
                    timeout = 0;
                    if (!this.getIsOpen()) ** GOTO lbl51
                    this.closeBase(isInternalCall);
                    try {
                        if (this.m_StreamRead != null) {
                            this.m_StreamRead.close();
                        }
                    }
                    catch (Exception oops) {
                        // empty catch block
                    }
                    try {
                        if (this.m_StreamWrite != null) {
                            this.m_StreamWrite.close();
                        }
                    }
                    catch (Exception oops) {
                        // empty catch block
                    }
                    try {
                        if (this.m_UdpClient != null) {
                            this.m_UdpClient.close();
                        }
                    }
                    catch (Exception oops) {
                        // empty catch block
                    }
                    try {
                        if (!this.m_Reconnecting && this.m_UdpListener != null) {
                            this.m_UdpListener.close();
                        }
                    }
                    catch (Exception oops) {
                        // empty catch block
                    }
                    this.m_StreamRead = null;
                    this.m_StreamWrite = null;
                    this.m_UdpClient = null;
                    if (!this.m_Reconnecting) {
                        this.m_UdpListener = null;
                    }
                    this.m_IsOpen = false;
                    this.m_IsActive = false;
                }
                catch (Exception oops) {
                }
                finally {
                    Monitor.exit(this.m_LockGeneral);
                }
            }
            if ((timeout -= 100) <= 0) continue;
            try {
                Thread.sleep(100L);
            }
            catch (Exception var3_9) {
                // empty catch block
            }
lbl51:
            // 6 sources

        } while (timeout > 0);
    }

    @Override
    protected int innerRead(byte[] buffer) throws IOException {
        return this.m_StreamRead.read(buffer);
    }

    @Override
    protected void innerWrite(byte[] buffer) throws IOException {
        this.m_StreamWrite.write(buffer);
        this.m_StreamWrite.flush();
    }

    @Override
    protected boolean innerListen() {
        boolean hasConnection = false;
        try {
            this.m_UdpClient = this.m_UdpListener.accept();
            this.m_StreamRead = new DataInputStream(this.m_UdpClient.getInputStream());
            this.m_StreamWrite = new DataOutputStream(this.m_UdpClient.getOutputStream());
            hasConnection = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hasConnection;
    }

    @Override
    protected String configSummary() {
        String results = "";
        results = "UDP " + (this.getIsServerMode() ? "(Server)" : "(Client)");
        return results;
    }

    @Override
    protected String configCompact() {
        String results = "";
        results = this.m_UdpClient.getRemoteSocketAddress() + ": " + this.m_UdpClient.getPort();
        return results;
    }

    @Override
    protected String configDetail() {
        String results = "";
        if (this.getIsServerMode()) {
            results = results + "UDP Server Settings\r\n   Port: " + this.m_Port;
        } else if (this.getIsClientMode()) {
            results = results + "UDP Client Settings\r\nTarget IP: " + this.m_UdpClient.getRemoteSocketAddress() + "\r\n" + "Port: " + this.m_UdpClient.getPort();
        }
        return results;
    }
}

