/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.connection;

import datamaxoneil.Monitor;
import datamaxoneil.connection.ConnectionBase;
import datamaxoneil.printer.configuration.GeneralConfiguration;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Connection_Serial
extends ConnectionBase {
    private RXTXPort m_Connection = null;
    private DataInputStream m_StreamRead = null;
    private DataOutputStream m_StreamWrite = null;
    private String m_Port;
    private int m_BaudRate;
    private RXTX_Parity m_Parity;
    private int m_DataBits;
    private StopBits m_StopBits;
    private RXTX_Handshake m_Handshaking;

    public String getPortName() {
        return this.m_Port;
    }

    public int getPortBaud() {
        return this.m_BaudRate;
    }

    public GeneralConfiguration.Parity getPortParity() {
        return this.m_Parity.localValue();
    }

    public int getPortDataBits() {
        return this.m_DataBits;
    }

    public StopBits getPortStopBits() {
        return this.m_StopBits;
    }

    public GeneralConfiguration.Handshake getHandshaking() {
        return this.m_Handshaking.localValue();
    }

    protected Connection_Serial(boolean isServer, String portName, int portBaud, GeneralConfiguration.Parity portParity, int portDataBits, StopBits portStopBits, GeneralConfiguration.Handshake portHandshaking) {
        super(isServer);
        if (portParity == RXTX_Parity.None.localValue()) {
            this.m_Parity = RXTX_Parity.None;
        } else if (portParity == RXTX_Parity.Even.localValue()) {
            this.m_Parity = RXTX_Parity.Even;
        } else if (portParity == RXTX_Parity.Odd.localValue()) {
            this.m_Parity = RXTX_Parity.Odd;
        } else {
            throw new IllegalArgumentException("Partiy value is not valid.");
        }
        if (portHandshaking == RXTX_Handshake.None.localValue()) {
            this.m_Handshaking = RXTX_Handshake.None;
        } else if (portHandshaking == RXTX_Handshake.Hardware.localValue()) {
            this.m_Handshaking = RXTX_Handshake.Hardware;
        } else if (portHandshaking == RXTX_Handshake.Software.localValue()) {
            this.m_Handshaking = RXTX_Handshake.Software;
        } else if (portHandshaking == RXTX_Handshake.Both.localValue()) {
            this.m_Handshaking = RXTX_Handshake.Both;
        } else {
            throw new IllegalArgumentException("Handshake value is not valid.");
        }
        this.m_Port = portName;
        this.m_BaudRate = portBaud;
        this.m_DataBits = portDataBits;
        this.m_StopBits = portStopBits;
    }

    public static Connection_Serial createClient(String portName, int portBaud, GeneralConfiguration.Parity portParity, int portDataBits, StopBits portStopBits, GeneralConfiguration.Handshake portHandshaking) {
        return new Connection_Serial(false, portName, portBaud, portParity, portDataBits, portStopBits, portHandshaking);
    }

    public static Connection_Serial createServer(String portName, int portBaud, GeneralConfiguration.Parity portParity, int portDataBits, StopBits portStopBits, GeneralConfiguration.Handshake portHandshaking) {
        return new Connection_Serial(true, portName, portBaud, portParity, portDataBits, portStopBits, portHandshaking);
    }

    @Override
    protected boolean getHasData() {
        boolean hasData = false;
        try {
            hasData = this.m_StreamRead.available() > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hasData;
    }

    @Override
    public boolean innerOpen() throws IOException {
        try {
            this.m_Connection = new RXTXPort(this.m_Port);
            this.m_Connection.setSerialPortParams(this.m_BaudRate, this.m_DataBits, this.m_StopBits.value(), this.m_Parity.value());
            this.m_Connection.setFlowControlMode(this.m_Handshaking.value());
            this.m_StreamRead = new DataInputStream(this.m_Connection.getInputStream());
            this.m_StreamWrite = new DataOutputStream(this.m_Connection.getOutputStream());
            this.m_IsActive = this.m_IsOpen = this.m_StreamRead != null && this.m_StreamWrite != null;
        }
        catch (PortInUseException oops) {
            throw new IOException(oops.getMessage());
        }
        catch (UnsupportedCommOperationException oops) {
            throw new IOException(oops.getMessage());
        }
        return this.m_IsOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void close(boolean isInternalCall) {
        v0 = timeout = isInternalCall != false ? 0 : 0x7FFFFFFF;
        do {
            if (Monitor.tryEnter(this.m_LockGeneral, 0L)) {
                try {
                    timeout = 0;
                    if (!this.getIsOpen()) ** GOTO lbl43
                    this.closeBase(isInternalCall);
                    try {
                        if (this.m_StreamRead != null) {
                            this.m_StreamRead.close();
                        }
                    }
                    catch (Exception oops) {
                        // empty catch block
                    }
                    try {
                        if (this.m_StreamWrite != null) {
                            this.m_StreamWrite.close();
                        }
                    }
                    catch (Exception oops) {
                        // empty catch block
                    }
                    try {
                        if (this.m_Connection != null) {
                            this.m_Connection.close();
                        }
                    }
                    catch (Exception oops) {
                        // empty catch block
                    }
                    this.m_StreamRead = null;
                    this.m_StreamWrite = null;
                    this.m_Connection = null;
                    this.m_IsOpen = false;
                    this.m_IsActive = false;
                }
                catch (Exception oops) {
                }
                finally {
                    Monitor.exit(this.m_LockGeneral);
                }
            }
            if ((timeout -= 100) <= 0) continue;
            try {
                Thread.sleep(100L);
            }
            catch (Exception var3_8) {
                // empty catch block
            }
lbl43:
            // 6 sources

        } while (timeout > 0);
    }

    @Override
    protected int innerRead(byte[] buffer) throws IOException {
        return this.m_StreamRead.read(buffer);
    }

    @Override
    protected void innerWrite(byte[] buffer) throws IOException {
        this.m_StreamWrite.write(buffer);
        this.m_StreamWrite.flush();
    }

    @Override
    protected boolean innerListen() {
        return true;
    }

    @Override
    protected String configSummary() {
        String results = "";
        results = "Serial " + (this.getIsServerMode() ? "(Server)" : "(Client)");
        return results;
    }

    @Override
    protected String configCompact() {
        String results = "";
        results = this.getPortName() + ": " + this.getPortBaud();
        return results;
    }

    @Override
    protected String configDetail() {
        String results = "";
        results = results + this.configSummary() + "\r\n" + "   Comm Port: " + this.getPortName() + "\r\n" + "   Baud Rate: " + this.getPortBaud() + "\r\n" + "   Parity: " + this.getPortParity().name() + "\r\n" + "   Data Bits: " + this.getPortDataBits() + "\r\n" + "   Stop Bits: " + (Object)((Object)this.getPortStopBits()) + "\r\n" + "   Handshake: " + this.getHandshaking().name();
        return results;
    }

    public static enum StopBits {
        One(1, "1"),
        Two(2, "2"),
        OnePointFive(3, "1.5");

        private final int m_Value;
        private final String m_Name;

        private StopBits(int value, String name) {
            this.m_Value = value;
            this.m_Name = name;
        }

        public int value() {
            return this.m_Value;
        }

        public String named() {
            return this.m_Name;
        }
    }

    protected static enum RXTX_Handshake {
        None(0, "None", GeneralConfiguration.Handshake.None),
        Software(4, "Software", GeneralConfiguration.Handshake.Software),
        Hardware(1, "Hardware", GeneralConfiguration.Handshake.Hardware),
        Both(5, "Both", GeneralConfiguration.Handshake.Both);

        private final int m_Value;
        private final String m_Name;
        private final GeneralConfiguration.Handshake m_LocalValue;

        private RXTX_Handshake(int value, String name, GeneralConfiguration.Handshake localValue) {
            this.m_Value = value;
            this.m_Name = name;
            this.m_LocalValue = localValue;
        }

        public int value() {
            return this.m_Value;
        }

        public String named() {
            return this.m_Name;
        }

        public GeneralConfiguration.Handshake localValue() {
            return this.m_LocalValue;
        }
    }

    protected static enum RXTX_Parity {
        None(0, "None", GeneralConfiguration.Parity.None),
        Odd(1, "Odd", GeneralConfiguration.Parity.Odd),
        Even(2, "Even", GeneralConfiguration.Parity.Even);

        private final int m_Value;
        private final String m_Name;
        private final GeneralConfiguration.Parity m_LocalValue;

        private RXTX_Parity(int value, String name, GeneralConfiguration.Parity localValue) {
            this.m_Value = value;
            this.m_Name = name;
            this.m_LocalValue = localValue;
        }

        public int value() {
            return this.m_Value;
        }

        public String named() {
            return this.m_Name;
        }

        public GeneralConfiguration.Parity localValue() {
            return this.m_LocalValue;
        }
    }
}

