/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.connection;

import datamaxoneil.Monitor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public abstract class ConnectionBase
extends Thread {
    protected Object m_LockGeneral = new Object();
    private Object m_DataLockRecv = new Object();
    private Object m_DataLockSend = new Object();
    private volatile boolean m_WorkerThreadActive = false;
    private ByteArrayOutputStream m_mStreamRecv = new ByteArrayOutputStream(1024);
    private boolean m_IsServerMode = false;
    protected boolean m_Reconnecting = false;
    private ArrayList<byte[]> m_DataStorageSend = new ArrayList();
    protected boolean m_IsOpen = false;
    protected boolean m_IsActive = false;
    private boolean m_IsClosing = false;
    boolean m_ClearTriggered = false;

    public boolean getIsOpen() {
        return this.m_IsOpen | this.m_Reconnecting;
    }

    public boolean getIsActive() {
        return this.m_IsActive;
    }

    public void setIsClosing(boolean isClosing) {
        this.m_IsClosing = isClosing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesAvailable() {
        long length;
        Object object = this.m_DataLockRecv;
        synchronized (object) {
            length = this.m_mStreamRecv.size();
        }
        return length;
    }

    public boolean getIsServerMode() {
        return this.m_IsServerMode;
    }

    public boolean getIsClientMode() {
        return !this.m_IsServerMode;
    }

    protected ConnectionBase(boolean isServer) {
        this.m_IsServerMode = isServer;
        this.setName("Communications");
        this.setDaemon(true);
        this.start();
    }

    protected void finalize() throws Throwable {
        System.out.println("finalize called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearReadBuffer() {
        Object object = this.m_DataLockRecv;
        synchronized (object) {
            this.m_mStreamRecv.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWriteBuffer() {
        Object object = this.m_DataLockSend;
        synchronized (object) {
            this.m_DataStorageSend.clear();
        }
    }

    public String read() {
        return this.read("", 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read(String endSequence, long msecTimeout) {
        String dataRead = "";
        long timeout = msecTimeout;
        if (!this.getIsOpen()) {
            throw new UnsupportedOperationException("Can not perform a Read on a Closed connection.");
        }
        if (this.m_IsClosing) {
            throw new UnsupportedOperationException("Can not perform a Read while the connection is in the process of being Closed.");
        }
        if (timeout == 0L) {
            byte[] data;
            int size;
            Object object = this.m_DataLockRecv;
            synchronized (object) {
                size = this.m_mStreamRecv.size();
                if (size == 0) {
                    return "";
                }
                data = this.m_mStreamRecv.toByteArray();
                this.m_mStreamRecv.reset();
            }
            char[] charArray = new char[size];
            for (int index = 0; index < size; ++index) {
                charArray[index] = (char)data[index];
            }
            dataRead = new String(charArray);
        } else {
            boolean foundFlag = false;
            boolean absoluteMode = timeout < 0L;
            long lastTime = System.currentTimeMillis();
            timeout = Math.abs(timeout);
            while (!foundFlag && System.currentTimeMillis() - lastTime < timeout) {
                byte[] data;
                int size;
                if (this.m_mStreamRecv.size() == 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ignore) {}
                    continue;
                }
                Object ignore = this.m_DataLockRecv;
                synchronized (ignore) {
                    size = this.m_mStreamRecv.size();
                    data = this.m_mStreamRecv.toByteArray();
                    this.m_mStreamRecv.reset();
                }
                char[] charArray = new char[size];
                for (int index = 0; index < size; ++index) {
                    charArray[index] = (char)data[index];
                }
                boolean bl = foundFlag = (dataRead = dataRead + new String(charArray)).indexOf(endSequence) != -1;
                if (absoluteMode) continue;
                lastTime = System.currentTimeMillis();
            }
        }
        return dataRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buffer, int offset, int length) {
        int lengthRead = 0;
        if (!this.getIsOpen()) {
            throw new UnsupportedOperationException("Can not perform a Read on a Closed connection.");
        }
        if (this.m_IsClosing) {
            throw new UnsupportedOperationException("Can not perform a Read while the connection is in the process of being Closed.");
        }
        Object object = this.m_DataLockRecv;
        synchronized (object) {
            if (this.m_mStreamRecv.size() == 0) {
                return 0;
            }
            byte[] data = this.m_mStreamRecv.toByteArray();
            if (this.m_mStreamRecv.size() <= length) {
                lengthRead = data.length;
                System.arraycopy(data, 0, buffer, offset, lengthRead);
                this.m_mStreamRecv.reset();
            } else {
                lengthRead = length;
                System.arraycopy(data, 0, buffer, offset, lengthRead);
                this.m_mStreamRecv.reset();
                this.m_mStreamRecv.write(data, length, data.length - lengthRead);
            }
        }
        return lengthRead;
    }

    public void write(String data) {
        byte[] dataArray = data.getBytes();
        this.write(dataArray, 0, dataArray.length);
    }

    public void write(byte[] buffer) {
        this.write(buffer, 0, buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buffer, int offset, int length) {
        byte[] copy = buffer == null ? new byte[]{} : new byte[Math.min(buffer.length - offset, length)];
        if (!this.getIsOpen()) {
            throw new UnsupportedOperationException("Can not perform a Write on a Closed connection.");
        }
        if (this.m_IsClosing) {
            throw new UnsupportedOperationException("Can not perform a Write while the connection is in the process of being Closed.");
        }
        for (int L1 = 0; L1 < copy.length; ++L1) {
            copy[L1] = buffer[L1 + offset];
        }
        Object object = this.m_DataLockSend;
        synchronized (object) {
            this.m_DataStorageSend.add(copy);
        }
    }

    public PrinterResponse waitResponse(int msecTimeout) {
        String buffer = "";
        byte[] readBuffer = new byte[1];
        long time = System.currentTimeMillis();
        if (!this.getIsOpen()) {
            throw new UnsupportedOperationException("Can not perform a WaitResponse on a Closed connection.");
        }
        if (this.m_IsClosing) {
            throw new UnsupportedOperationException("Can not perform a WaitResponse while the connection is in the process of being Closed.");
        }
        while (System.currentTimeMillis() - time < (long)msecTimeout) {
            if (this.read(readBuffer, 0, 1) == 0) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ignore) {}
                continue;
            }
            String string = buffer = buffer.length() == 5 ? buffer.substring(1) + (char)readBuffer[0] : buffer + (char)readBuffer[0];
            if (buffer.indexOf("{") != -1) {
                buffer = buffer.substring(buffer.indexOf("{"));
            }
            if (buffer.length() < 5 || buffer.length() != 5 || !buffer.startsWith("{") || !buffer.endsWith("}")) continue;
            PrinterResponse result = PrinterResponse.Unknown;
            if (buffer.startsWith("{A")) {
                result = PrinterResponse.ACK;
            } else if (buffer.startsWith("{N")) {
                result = PrinterResponse.NAK;
            } else if (buffer.startsWith("{W")) {
                result = PrinterResponse.WRITING;
            } else if (buffer.startsWith("{R")) {
                result = PrinterResponse.RESUME;
            } else if (buffer.startsWith("{D")) {
                result = PrinterResponse.DONE;
            }
            return result;
        }
        return PrinterResponse.Unknown;
    }

    protected abstract boolean getHasData();

    public synchronized boolean open() throws IOException {
        boolean results = true;
        try {
            Monitor.enter(this.m_LockGeneral);
            if (!this.m_IsOpen) {
                results = this.innerOpen();
                if (this.m_IsOpen) {
                    if (!this.m_WorkerThreadActive) {
                        this.m_Reconnecting = false;
                        this.m_IsClosing = false;
                        this.m_WorkerThreadActive = true;
                        this.notify();
                    }
                    this.m_Reconnecting = false;
                }
            }
        }
        finally {
            Monitor.exit(this.m_LockGeneral);
        }
        return results;
    }

    protected abstract boolean innerOpen() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForEmptyBuffer(int timeout_msec) {
        long endTime = System.currentTimeMillis() + (long)timeout_msec;
        if (!this.getIsActive()) {
            return true;
        }
        while (System.currentTimeMillis() < endTime) {
            Object object = this.m_DataLockSend;
            synchronized (object) {
                if (this.m_DataStorageSend.size() == 0) {
                    return true;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignore) {}
        }
        return false;
    }

    public void close() {
        this.close(false);
    }

    protected abstract void close(boolean var1);

    protected void closeBase(boolean isInternalCall) {
        this.m_IsClosing = true;
        if (!isInternalCall) {
            while (this.m_WorkerThreadActive) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected abstract int innerRead(byte[] var1) throws IOException;

    protected abstract void innerWrite(byte[] var1) throws IOException;

    protected abstract boolean innerListen();

    protected abstract String configSummary();

    protected abstract String configCompact();

    protected abstract String configDetail();

    @Override
    public String toString() {
        return this.toString("L");
    }

    public String toString(String format) {
        String results = "";
        if (format == "L") {
            results = this.configDetail();
        } else if (format == "S") {
            results = this.configSummary();
        } else {
            throw new IllegalArgumentException("ToString parameter must be 'L' or 'S'");
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean doRunRun = true;
        while (doRunRun) {
            try {
                ConnectionBase connectionBase = this;
                synchronized (connectionBase) {
                    while (!this.m_WorkerThreadActive) {
                        this.wait(1000L);
                    }
                }
                this.runInternal();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_WorkerThreadActive = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void runInternal() {
        boolean oneTry = true;
        boolean shouldSleep = false;
        boolean doReconnect = false;
        byte[] buffer = new byte[65536];
        byte[] sendItem = null;
        this.m_Reconnecting = false;
        this.m_IsClosing = false;
        try {
            if (!this.m_IsOpen) {
                this.m_IsActive = false;
                this.m_IsClosing = true;
            }
            block24: while (oneTry || !this.m_IsClosing) {
                oneTry = false;
                if (this.getIsServerMode()) {
                    if (this.m_IsActive) {
                        this.m_IsActive = false;
                    }
                    if (!this.innerListen()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ignore) {}
                        continue;
                    }
                }
                this.m_IsActive = true;
                while (this.getIsActive()) {
                    block37: {
                        if (shouldSleep && !doReconnect) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException ignore) {
                                // empty catch block
                            }
                        }
                        shouldSleep = true;
                        if (doReconnect) {
                            if (Monitor.tryEnter(this.m_LockGeneral, 0L)) {
                                try {
                                    doReconnect = false;
                                    this.m_Reconnecting = true;
                                    this.close(true);
                                    try {
                                        Thread.sleep(500L);
                                    }
                                    catch (InterruptedException ignore) {
                                        // empty catch block
                                    }
                                    this.open();
                                    this.m_IsClosing = false;
                                    if (this.getIsServerMode()) {
                                        this.m_IsActive = false;
                                        continue;
                                    }
                                    break block37;
                                }
                                catch (Exception error) {
                                    throw new Exception("Reconnect failed: " + error.getLocalizedMessage());
                                }
                                finally {
                                    Monitor.exit(this.m_LockGeneral);
                                    continue;
                                }
                            }
                            if (!this.m_IsClosing) continue;
                            continue block24;
                        }
                    }
                    Object error = this.m_DataLockSend;
                    // MONITORENTER : error
                    sendItem = null;
                    this.m_ClearTriggered = false;
                    if (this.m_DataStorageSend.size() > 0) {
                        sendItem = this.m_DataStorageSend.get(0);
                    }
                    // MONITOREXIT : error
                    if (sendItem != null) {
                        try {
                            shouldSleep = false;
                            this.innerWrite(sendItem);
                            error = this.m_DataLockSend;
                            // MONITORENTER : error
                            if (!this.m_ClearTriggered) {
                                this.m_DataStorageSend.remove(0);
                            }
                            // MONITOREXIT : error
                        }
                        catch (Exception ignore) {
                            doReconnect = true;
                            continue;
                        }
                    }
                    if (this.m_IsClosing && this.m_DataStorageSend.size() == 0) continue block24;
                    if (!this.getHasData()) continue;
                    Object ignore = this.m_DataLockRecv;
                    // MONITORENTER : ignore
                    int length = this.innerRead(buffer);
                    this.m_mStreamRecv.write(buffer, 0, length);
                    shouldSleep = false;
                    // MONITOREXIT : ignore
                }
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.m_Reconnecting = false;
            this.close(true);
            this.m_IsActive = false;
            this.m_IsOpen = false;
            this.m_IsClosing = false;
            return;
        }
        finally {
            this.clearWriteBuffer();
        }
    }

    public static enum PrinterResponse {
        Unknown,
        ACK,
        NAK,
        WRITING,
        RESUME,
        DONE;

    }
}

