/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil;

import java.util.HashMap;

public class Monitor {
    private static Object m_LockGateway = new Object();
    private static HashMap<Object, LockData> m_Locks = new HashMap();

    public static void enter(Object lockObject) {
        if (lockObject == null) {
            throw new IllegalArgumentException("lockObject was null");
        }
        while (!Monitor.tryEnter(lockObject, 0L)) {
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit(Object lockObject) {
        if (lockObject == null) {
            throw new IllegalArgumentException("lockObject was null");
        }
        Object object = m_LockGateway;
        synchronized (object) {
            if (!m_Locks.containsKey(lockObject)) {
                throw new IllegalStateException("Monitor.exit called on object that is not currently locked.");
            }
            LockData lData = m_Locks.get(lockObject);
            if (lData.owningThread != Thread.currentThread()) {
                throw new IllegalStateException("Monitor.exit called on object that is lock by another thread.");
            }
            --lData.lockCount;
            if (lData.lockCount == 0L) {
                m_Locks.remove(lockObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryEnter(Object lockObject, long timeout) {
        boolean result = false;
        if (lockObject == null) {
            throw new IllegalArgumentException("lockObject was null");
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout was negative");
        }
        long startTime = System.currentTimeMillis();
        do {
            Object object = m_LockGateway;
            synchronized (object) {
                LockData lData;
                if (!m_Locks.containsKey(lockObject)) {
                    Monitor monitor = new Monitor();
                    monitor.getClass();
                    lData = monitor.new LockData();
                    lData.owningThread = Thread.currentThread();
                    lData.lockCount = 1L;
                    m_Locks.put(lockObject, lData);
                    result = true;
                } else {
                    lData = m_Locks.get(lockObject);
                    if (lData.owningThread == Thread.currentThread()) {
                        ++lData.lockCount;
                        result = true;
                    }
                }
            }
            Thread.yield();
        } while (System.currentTimeMillis() - startTime <= timeout && !result);
        return result;
    }

    private class LockData {
        public Thread owningThread = null;
        public long lockCount = 0L;

        private LockData() {
        }
    }
}

