/*
 * Decompiled with CFR 0.152.
 */
package com.smsglobal.transport;

import com.smsglobal.client.Message;
import com.smsglobal.client.Transport;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;

public class HttpTransport
implements Transport {
    private String action = "sendsms";
    private String username;
    private String password;
    private String baseUrl;
    private URI uri;

    public HttpTransport(String username, String password, String baseUrl) throws URISyntaxException {
        this.username = username;
        this.password = password;
        this.baseUrl = baseUrl;
        this.uri = new URI(baseUrl);
    }

    @Override
    public String sendMessage(Message message) throws Exception {
        String url = this.buildUrl(message);
        Content response = Request.Get((String)url).execute().returnContent();
        return response.asString();
    }

    public String buildUrl(Message message) {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.uri.getScheme());
        builder.setHost(this.uri.getHost());
        builder.setPath(this.uri.getPath());
        builder.addParameter("action", this.action);
        builder.addParameter("user", this.username);
        builder.addParameter("password", this.password);
        builder.addParameter("from", message.getOrigin());
        builder.addParameter("to", message.getDestination());
        builder.addParameter("text", message.getMessage());
        return builder.toString();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

