/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yp.scrape.model;

import com.anahata.yp.scrape.model.Category;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Group
implements Serializable {
    private Group parent;
    private List<Long> categories;
    private List<Group> children;
    private Long id;
    private String name;

    public void setParentOnChildren() {
        if (this.children != null) {
            for (Group g : this.children) {
                g.parent = this;
                g.setParentOnChildren();
            }
        }
    }

    public boolean hasCategory(Long id) {
        if (this.categories != null && this.categories.contains(id)) {
            return true;
        }
        if (this.children != null) {
            for (Group group : this.children) {
                if (!group.hasCategory(id)) continue;
                return true;
            }
        }
        return false;
    }

    public Group findGroup(Category category) {
        if (this.categories != null && this.categories.contains(category.getId())) {
            return this;
        }
        if (this.children != null) {
            for (Group group : this.children) {
                Group categoryParent = group.findGroup(category);
                if (categoryParent == null) continue;
                return categoryParent;
            }
        }
        return null;
    }

    public List<Group> getPathToRoot() {
        Group current = this;
        ArrayList<Group> ret = new ArrayList<Group>();
        ret.add(current);
        while (current.getParent() != null) {
            current = current.getParent();
            ret.add(current);
        }
        Collections.reverse(ret);
        return ret;
    }

    public int countByDepth(int depth) {
        int thisDepth = this.getPathToRoot().size();
        if (thisDepth == depth) {
            return 1;
        }
        int sum = 0;
        if (thisDepth < depth && this.children != null) {
            for (Group group : this.children) {
                sum += group.countByDepth(depth);
            }
        }
        return sum;
    }

    public String toString() {
        return this.name;
    }

    public Group getParent() {
        return this.parent;
    }

    public List<Long> getCategories() {
        return this.categories;
    }

    public List<Group> getChildren() {
        return this.children;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setParent(Group parent) {
        this.parent = parent;
    }

    public void setCategories(List<Long> categories) {
        this.categories = categories;
    }

    public void setChildren(List<Group> children) {
        this.children = children;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }
}

