/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yp.scrape;

import com.anahata.yp.api.model.Contact;
import com.anahata.yp.api.model.Listing;
import com.anahata.yp.scrape.model.Company;

public class ReportLine
implements Comparable<ReportLine> {
    private String name;
    private String description;
    private String serviceNotes;
    private boolean pureMobileBusiness;
    private String abn;
    private String acn;
    private String numberOfEmployees;
    private String dateEstablished;
    private String email;
    private String phone;
    private String mobile;
    private String fax;
    private String url;
    private String international;
    private String pager;
    private String addressType;
    private String address;
    private String category;

    public ReportLine() {
    }

    public ReportLine(Company company) {
        this.name = company.getName();
        this.email = company.getEmail();
        this.url = company.getWeb();
        this.address = company.getAddress();
        this.phone = company.getPhone();
        this.category = company.getCategory().getName();
    }

    public ReportLine(Listing listing) {
        this.name = listing.getName();
        this.description = listing.getShortDescriptor();
        this.serviceNotes = listing.getServiceNotes();
        this.pureMobileBusiness = listing.isPureMobileBusiness();
        if (listing.getBusinessInfo() != null) {
            this.abn = listing.getBusinessInfo().getAbn();
            this.acn = listing.getBusinessInfo().getAcn();
            this.numberOfEmployees = listing.getBusinessInfo().getNumberOfEmployees();
            this.dateEstablished = listing.getBusinessInfo().getDateEstablished();
        } else {
            this.abn = "";
            this.acn = "";
            this.numberOfEmployees = "";
            this.dateEstablished = "";
        }
        for (Contact contact : listing.getPrimaryContacts()) {
            switch (contact.getType()) {
                case EMAIL: {
                    this.email = contact.getValue();
                    break;
                }
                case PHONE: {
                    this.phone = contact.getValue();
                    break;
                }
                case MOBILE: {
                    this.mobile = contact.getValue();
                    break;
                }
                case FAX: {
                    this.fax = contact.getValue();
                    break;
                }
                case URL: {
                    this.url = contact.getValue();
                    break;
                }
                case INTERNATIONAL: {
                    this.international = contact.getValue();
                    break;
                }
                case PAGER: {
                    this.pager = contact.getValue();
                }
            }
        }
        this.addressType = listing.getPrimaryAddress().getType();
        this.address = listing.getPrimaryAddress().getDisplayValue();
    }

    @Override
    public int compareTo(ReportLine o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReportLine)) {
            return false;
        }
        ReportLine other = (ReportLine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$serviceNotes = this.getServiceNotes();
        String other$serviceNotes = other.getServiceNotes();
        if (this$serviceNotes == null ? other$serviceNotes != null : !this$serviceNotes.equals(other$serviceNotes)) {
            return false;
        }
        if (this.isPureMobileBusiness() != other.isPureMobileBusiness()) {
            return false;
        }
        String this$abn = this.getAbn();
        String other$abn = other.getAbn();
        if (this$abn == null ? other$abn != null : !this$abn.equals(other$abn)) {
            return false;
        }
        String this$acn = this.getAcn();
        String other$acn = other.getAcn();
        if (this$acn == null ? other$acn != null : !this$acn.equals(other$acn)) {
            return false;
        }
        String this$numberOfEmployees = this.getNumberOfEmployees();
        String other$numberOfEmployees = other.getNumberOfEmployees();
        if (this$numberOfEmployees == null ? other$numberOfEmployees != null : !this$numberOfEmployees.equals(other$numberOfEmployees)) {
            return false;
        }
        String this$dateEstablished = this.getDateEstablished();
        String other$dateEstablished = other.getDateEstablished();
        if (this$dateEstablished == null ? other$dateEstablished != null : !this$dateEstablished.equals(other$dateEstablished)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        String this$fax = this.getFax();
        String other$fax = other.getFax();
        if (this$fax == null ? other$fax != null : !this$fax.equals(other$fax)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$international = this.getInternational();
        String other$international = other.getInternational();
        if (this$international == null ? other$international != null : !this$international.equals(other$international)) {
            return false;
        }
        String this$pager = this.getPager();
        String other$pager = other.getPager();
        if (this$pager == null ? other$pager != null : !this$pager.equals(other$pager)) {
            return false;
        }
        String this$addressType = this.getAddressType();
        String other$addressType = other.getAddressType();
        if (this$addressType == null ? other$addressType != null : !this$addressType.equals(other$addressType)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        return !(this$category == null ? other$category != null : !this$category.equals(other$category));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReportLine;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $serviceNotes = this.getServiceNotes();
        result = result * 59 + ($serviceNotes == null ? 43 : $serviceNotes.hashCode());
        result = result * 59 + (this.isPureMobileBusiness() ? 79 : 97);
        String $abn = this.getAbn();
        result = result * 59 + ($abn == null ? 43 : $abn.hashCode());
        String $acn = this.getAcn();
        result = result * 59 + ($acn == null ? 43 : $acn.hashCode());
        String $numberOfEmployees = this.getNumberOfEmployees();
        result = result * 59 + ($numberOfEmployees == null ? 43 : $numberOfEmployees.hashCode());
        String $dateEstablished = this.getDateEstablished();
        result = result * 59 + ($dateEstablished == null ? 43 : $dateEstablished.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        String $fax = this.getFax();
        result = result * 59 + ($fax == null ? 43 : $fax.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $international = this.getInternational();
        result = result * 59 + ($international == null ? 43 : $international.hashCode());
        String $pager = this.getPager();
        result = result * 59 + ($pager == null ? 43 : $pager.hashCode());
        String $addressType = this.getAddressType();
        result = result * 59 + ($addressType == null ? 43 : $addressType.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getServiceNotes() {
        return this.serviceNotes;
    }

    public boolean isPureMobileBusiness() {
        return this.pureMobileBusiness;
    }

    public String getAbn() {
        return this.abn;
    }

    public String getAcn() {
        return this.acn;
    }

    public String getNumberOfEmployees() {
        return this.numberOfEmployees;
    }

    public String getDateEstablished() {
        return this.dateEstablished;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getFax() {
        return this.fax;
    }

    public String getUrl() {
        return this.url;
    }

    public String getInternational() {
        return this.international;
    }

    public String getPager() {
        return this.pager;
    }

    public String getAddressType() {
        return this.addressType;
    }

    public String getAddress() {
        return this.address;
    }

    public String getCategory() {
        return this.category;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setServiceNotes(String serviceNotes) {
        this.serviceNotes = serviceNotes;
    }

    public void setPureMobileBusiness(boolean pureMobileBusiness) {
        this.pureMobileBusiness = pureMobileBusiness;
    }

    public void setAbn(String abn) {
        this.abn = abn;
    }

    public void setAcn(String acn) {
        this.acn = acn;
    }

    public void setNumberOfEmployees(String numberOfEmployees) {
        this.numberOfEmployees = numberOfEmployees;
    }

    public void setDateEstablished(String dateEstablished) {
        this.dateEstablished = dateEstablished;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setInternational(String international) {
        this.international = international;
    }

    public void setPager(String pager) {
        this.pager = pager;
    }

    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setCategory(String category) {
        this.category = category;
    }
}

