/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yp.scrape;

import com.anahata.util.csv.ExcelToCsvConverter;
import com.anahata.util.lang.AnahataCollectionUtils;
import com.anahata.yp.api.model.Listing;
import com.anahata.yp.api.model.SearchResult;
import com.anahata.yp.scrape.ReportLine;
import com.anahata.yp.scrape.model.Company;
import com.anahata.yp.scrape.model.Group;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelReport {
    private static final Logger log = LoggerFactory.getLogger(ExcelReport.class);

    public void runSearchResult(SearchResult searchResult, String outputFileName) throws Exception {
        TreeSet<ReportLine> report = new TreeSet<ReportLine>();
        for (Listing listing : searchResult.getResults()) {
            ReportLine reportLine = new ReportLine(listing);
            report.add(reportLine);
        }
        this.run(report, outputFileName);
    }

    public void deleteExcelAndCsv(File dir) {
        for (File f : dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String nameLower = name.toLowerCase();
                return nameLower.endsWith("xlsx") || nameLower.endsWith("xls") || nameLower.endsWith("csv");
            }
        })) {
            log.debug("Deleting " + f);
            f.delete();
        }
    }

    public void runCompanies(Collection<Company> companies, File outputFile) throws Exception {
        log.debug("Outputting {} companies to excel and csv", (Object)companies.size());
        File dir = outputFile.getParentFile();
        String baseName = FilenameUtils.getBaseName((String)outputFile.getName());
        String extension = FilenameUtils.getExtension((String)outputFile.getName());
        int maxSize = 35000;
        List chunks = AnahataCollectionUtils.split(companies, (int)maxSize);
        int idx = 0;
        for (List chunk : chunks) {
            String excelName = baseName + "-" + idx + "." + extension;
            File chunkFile = new File(dir, excelName);
            log.debug("Generating {} with {}", (Object)chunkFile, (Object)chunk.size());
            this.runCompaniesImpl(chunk, chunkFile);
            log.debug("Generating csv");
            new ExcelToCsvConverter().convertExcelToCSV(chunkFile.getAbsolutePath(), dir.getAbsolutePath());
            ++idx;
        }
    }

    private Workbook runCompaniesImpl(Collection<Company> companies, File outputFile) throws Exception {
        XSSFWorkbook wb = new XSSFWorkbook();
        Sheet sheet = wb.createSheet("Businesses");
        Row row = sheet.createRow(0);
        int c = 0;
        Cell firstCell = row.createCell(c++);
        firstCell.setCellValue("ID");
        row.createCell(c++).setCellValue("YP group 1");
        row.createCell(c++).setCellValue("YP Group 2");
        row.createCell(c++).setCellValue("YP Group 3");
        row.createCell(c++).setCellValue("YP Group 4");
        row.createCell(c++).setCellValue("YP Group 5");
        row.createCell(c++).setCellValue("YP Category");
        row.createCell(c++).setCellValue("YP Full Path");
        row.createCell(c++).setCellValue("Account Name");
        row.createCell(c++).setCellValue("Email Address");
        row.createCell(c++).setCellValue("YP Website");
        row.createCell(c++).setCellValue("YP Logo");
        row.createCell(c++).setCellValue("Office Phone");
        row.createCell(c++).setCellValue("Primary Address Street");
        row.createCell(c++).setCellValue("Primary Address City");
        row.createCell(c++).setCellValue("Primary Address State");
        row.createCell(c++).setCellValue("Primary Address Postal Code");
        row.createCell(c++).setCellValue("Primary Address Country");
        int r = 1;
        Cell lastCell = null;
        for (Company company : companies) {
            row = sheet.createRow(r++);
            c = 0;
            row.createCell(c++).setCellValue("yp-" + company.getId());
            List<Group> groupPath = company.getCategory().getGroupPath();
            for (int i = 0; i < 5; ++i) {
                if (groupPath.size() > i) {
                    row.createCell(c++).setCellValue(groupPath.get(i).getName());
                    continue;
                }
                row.createCell(c++).setCellValue("");
            }
            row.createCell(c++).setCellValue(company.getCategory().getName());
            row.createCell(c++).setCellValue(company.getCategory().getFullPath());
            row.createCell(c++).setCellValue(company.getName());
            row.createCell(c++).setCellValue(company.getEmail());
            row.createCell(c++).setCellValue(StringUtils.isEmpty((CharSequence)company.getWeb()) ? "your web site" : company.getWeb());
            row.createCell(c++).setCellValue(StringUtils.isEmpty((CharSequence)company.getLogo()) ? "https://upload.wikimedia.org/wikipedia/commons/c/ce/Transparent.gif" : company.getLogo());
            row.createCell(c++).setCellValue(company.getPhone());
            row.createCell(c++).setCellValue(company.getAddress());
            row.createCell(c++).setCellValue(company.getLocality());
            row.createCell(c++).setCellValue(company.getState());
            row.createCell(c++).setCellValue(company.getPostCode());
            lastCell = row.createCell(c++);
            lastCell.setCellValue("Australia");
        }
        sheet.setAutoFilter(new CellRangeAddress(firstCell.getRowIndex(), lastCell.getRowIndex(), firstCell.getColumnIndex(), lastCell.getColumnIndex()));
        sheet.createFreezePane(0, 1);
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            wb.write((OutputStream)fos);
        }
        return wb;
    }

    public void run(Collection<ReportLine> report, String outputFileName) throws Exception {
        XSSFWorkbook wb = new XSSFWorkbook();
        Sheet sheet = wb.createSheet("Businesses");
        Row row = sheet.createRow(0);
        int c = 0;
        Cell firstCell = row.createCell(c++);
        firstCell.setCellValue("Business Name");
        row.createCell(c++).setCellValue("Description");
        row.createCell(c++).setCellValue("Service Notes");
        row.createCell(c++).setCellValue("Mobile");
        row.createCell(c++).setCellValue("ABN");
        row.createCell(c++).setCellValue("ACN");
        row.createCell(c++).setCellValue("Num Employees");
        row.createCell(c++).setCellValue("Date Established");
        row.createCell(c++).setCellValue("Email");
        row.createCell(c++).setCellValue("Phone");
        row.createCell(c++).setCellValue("Mobile");
        row.createCell(c++).setCellValue("Fax");
        row.createCell(c++).setCellValue("Web Site");
        row.createCell(c++).setCellValue("International");
        row.createCell(c++).setCellValue("Pager");
        row.createCell(c++).setCellValue("Addr Type");
        row.createCell(c++).setCellValue("Address");
        int r = 1;
        Cell lastCell = null;
        for (ReportLine reportLine : report) {
            row = sheet.createRow(r++);
            c = 0;
            row.createCell(c++).setCellValue(reportLine.getName());
            row.createCell(c++).setCellValue(reportLine.getDescription());
            row.createCell(c++).setCellValue(reportLine.getServiceNotes());
            row.createCell(c++).setCellValue(reportLine.isPureMobileBusiness());
            row.createCell(c++).setCellValue(reportLine.getAbn());
            row.createCell(c++).setCellValue(reportLine.getAcn());
            row.createCell(c++).setCellValue(reportLine.getNumberOfEmployees());
            row.createCell(c++).setCellValue(reportLine.getDateEstablished());
            row.createCell(c++).setCellValue(reportLine.getEmail());
            row.createCell(c++).setCellValue(reportLine.getPhone());
            row.createCell(c++).setCellValue(reportLine.getMobile());
            row.createCell(c++).setCellValue(reportLine.getFax());
            row.createCell(c++).setCellValue(reportLine.getUrl());
            row.createCell(c++).setCellValue(reportLine.getInternational());
            row.createCell(c++).setCellValue(reportLine.getPager());
            row.createCell(c++).setCellValue(reportLine.getAddressType());
            lastCell = row.createCell(c++);
            lastCell.setCellValue(reportLine.getAddress());
        }
        sheet.setAutoFilter(new CellRangeAddress(firstCell.getRowIndex(), lastCell.getRowIndex(), firstCell.getColumnIndex(), lastCell.getColumnIndex()));
        sheet.createFreezePane(0, 1);
        try (FileOutputStream fos = new FileOutputStream(outputFileName);){
            wb.write((OutputStream)fos);
        }
    }
}

