/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yp.scrape;

import com.anahata.yp.api.model.Listing;
import com.anahata.yp.api.model.SearchResult;
import com.anahata.yp.scrape.CsvLineBuilder;
import java.beans.ConstructorProperties;
import java.io.PrintStream;

public class CsvReport {
    private SearchResult searchResult;
    private PrintStream out;

    public void run() {
        this.out.printf("Query: %s Date: %s Paged Results: %d Total Results: %d%n%n", this.searchResult.getOriginalQuery(), this.searchResult.getDate(), this.searchResult.getCount(), this.searchResult.getTotalResults());
        this.out.println("Business Name,Description,Service Notes,Mobile,ABN,ACN,Num Employees,Date Established,Addr Type,Address");
        for (Listing listing : this.searchResult.getResults()) {
            CsvLineBuilder b = new CsvLineBuilder();
            b.append(listing.getName());
            b.append(listing.getShortDescriptor());
            b.append(listing.getServiceNotes());
            b.append(listing.isPureMobileBusiness());
            if (listing.getBusinessInfo() != null) {
                b.append(listing.getBusinessInfo().getAbn());
                b.append(listing.getBusinessInfo().getAcn());
                b.append(listing.getBusinessInfo().getNumberOfEmployees());
                b.append(listing.getBusinessInfo().getDateEstablished());
            } else {
                b.append("");
                b.append("");
                b.append("");
                b.append("");
            }
            b.append(listing.getPrimaryAddress().getType());
            b.append(listing.getPrimaryAddress().getDisplayValue());
            this.out.println(b.toString());
        }
    }

    @ConstructorProperties(value={"searchResult", "out"})
    public CsvReport(SearchResult searchResult, PrintStream out) {
        this.searchResult = searchResult;
        this.out = out;
    }
}

