/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yp.scrape;

import com.anahata.yp.scrape.model.Categories;
import com.anahata.yp.scrape.model.Category;
import com.anahata.yp.scrape.model.CategoryGroups;
import com.google.gson.Gson;
import java.io.File;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class CategoryData {
    static String CATEGORIES_URL = "http://api.sensis.com.au/ob-20110511/test/metadata/categories?key=bfrkj8x4w76y93brpbuh8an5";
    static String CATEGORY_GROUPS_URL = "http://api.sensis.com.au/ob-20110511/test/metadata/categoryGroups?key=bfrkj8x4w76y93brpbuh8an5";
    private static List<Category> categories;
    private static CategoryGroups categoryGroups;

    public static List<Category> getCategories() throws Exception {
        return categories;
    }

    public static void main(String[] args) throws Exception {
        int maxDepth = 0;
        for (Category g : CategoryData.getCategories()) {
            System.out.println(g + " " + g.getGroupPath().size());
            maxDepth = Math.max(g.getGroupPath().size(), maxDepth);
        }
        System.out.println("Total categories: " + CategoryData.getCategories().size());
        System.out.println("maxDepth " + maxDepth);
    }

    static {
        Gson gson = new Gson();
        File f = new File("downloaded/categories.json");
        try {
            FileUtils.copyURLToFile((URL)new URL(CATEGORIES_URL), (File)f);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Will reuse previously loaded file");
        }
        try {
            String categoriesString = FileUtils.readFileToString((File)f);
            categories = ((Categories)gson.fromJson(categoriesString, Categories.class)).getCategories();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

