/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yp.scrape;

import com.anahata.yp.api.model.SearchResult;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

public class App {
    private static final String API_SEARCH_URL = "http://api.sensis.com.au/ob-20110511/test/search";
    private static final String API_KEY = "bfrkj8x4w76y93brpbuh8an5";
    private Gson gson = new Gson();

    public static void main(String[] args) throws Exception {
        new App().search("CTS", "Perth");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(String query, String location) throws Exception {
        URL searchUrl = this.buildUrl(query, location, 1);
        HttpURLConnection conn = (HttpURLConnection)searchUrl.openConnection();
        conn.connect();
        try {
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Error calling Search API HTTP status=" + conn.getResponseCode());
            }
            try (InputStream stream = conn.getInputStream();){
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(stream, "UTF-8"));
                SearchResult result = (SearchResult)this.gson.fromJson(reader, SearchResult.class);
                System.out.println(result);
            }
        }
        finally {
            conn.disconnect();
        }
    }

    private URL buildUrl(String query, String location, int page) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(API_SEARCH_URL);
        sb.append("?key=").append(API_KEY);
        sb.append("&query=").append(URLEncoder.encode(query, "UTF-8"));
        sb.append("&location=").append(URLEncoder.encode(location, "UTF-8"));
        sb.append("&state=WA");
        sb.append("&includePois=false");
        sb.append("&rows=50");
        sb.append("&page=").append(page);
        return new URL(sb.toString());
    }
}

