/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yp.migrator;

import com.anahata.util.validation.ValidationUtils;
import com.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordMigrator {
    private static final Logger log = LoggerFactory.getLogger(RecordMigrator.class);
    HSSFWorkbook workbook;
    HSSFWorkbook workbookNew;
    public static final String fileName = System.getProperty("user.home") + File.separator + "IT Victoria on 12102016.csv";
    private static final String COMMA_DELIMITER = ",";
    private static final String NEW_LINE_SEPARATOR = "\n";
    private static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private Map<String, String[]> contacts = new HashMap<String, String[]>();
    private String path = "C:\\Users\\Arslan\\Vic";
    private File dir = new File(this.path);
    private Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
    private Matcher matcher;

    private void csvReader() throws IOException {
        if (this.dir != null && this.dir.isDirectory()) {
            String[] fileNames = this.dir.list();
            for (String fileName : fileNames) {
                CSVReader reader = new CSVReader((Reader)new FileReader(this.dir.getAbsolutePath() + File.separator + fileName));
                List entries = reader.readAll();
                System.out.println("fileName " + fileName + " entries " + entries.size());
                for (String[] str : entries) {
                    if (this.contacts.containsKey(str[0].trim()) || str[8].trim() == null || str[8].trim().isEmpty()) continue;
                    this.contacts.put(str[0].trim(), str);
                }
            }
            System.out.println("Reading Finished!");
            System.out.println("Writing Start!");
            System.out.println("Total Contacts !" + this.contacts.size());
            for (String[] str : this.contacts.values()) {
                RecordMigrator.writeCsvFile(str);
            }
            System.out.println("Writing Finished!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCsvFile(String[] row) {
        OutputStreamWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(fileName, true);
            for (String str : row) {
                fileWriter.append(str);
                fileWriter.append(COMMA_DELIMITER);
            }
            fileWriter.append(NEW_LINE_SEPARATOR);
        }
        catch (Exception e) {
            System.out.println("Error in CsvFileWriter !!!");
            e.printStackTrace();
        }
        finally {
            try {
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException e) {
                System.out.println("Error while flushing/closing fileWriter !!!");
                e.printStackTrace();
            }
        }
    }

    private boolean validate(String hex) {
        this.matcher = this.pattern.matcher(hex);
        return this.matcher.matches();
    }

    public static void main(String[] p) {
        try {
            new RecordMigrator().csvReader();
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = ValidationUtils.getConstraintValidationDetails((Throwable)e);
        }
    }
}

