/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yp.docmosis;

import lombok.NonNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlDocumentPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(HtmlDocumentPostProcessor.class);

    public static String processHtml(@NonNull String html) {
        if (html == null) {
            throw new NullPointerException("html");
        }
        Document doc = Jsoup.parse((String)html);
        Elements styles = doc.select("html > head > style");
        if (styles.size() == 1) {
            Element style = styles.first();
            style.text("P { margin-top: 0; margin-bottom: 0; }\nA {color:green; text-decoration:none; border:0; color:green;}");
        } else {
            System.out.println("Could not find style header in " + html);
        }
        return doc.outerHtml();
    }

    private HtmlDocumentPostProcessor() {
    }
}

