/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yp.api.sensis.sapi.scraper;

import com.anahata.util.lang.Nvl;
import com.anahata.yp.api.sensis.sapi.scraper.Contact;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class SSAPI {
    private Random random = new Random();
    private String currentKey;
    long lastCall;
    private List<String> keys = new ArrayList<String>(Arrays.asList("hrhspvhgagk9hukek6tr8kp9", "ujhbcja9hv7uc9xdyymk4tus", "yet56dk78pn7bquw4dqrnrwx", "vkb5edm348nku9twn78t7rkq", "bfrkj8x4w76y93brpbuh8an5"));

    private String getKey() {
        if (this.currentKey == null) {
            this.currentKey = this.keys.get(this.random.nextInt(this.keys.size()));
        }
        return this.currentKey;
    }

    private void banKey() {
        this.keys.remove(this.currentKey);
        this.currentKey = null;
        if (!this.keys.isEmpty()) {
            this.getKey();
        } else {
            System.err.println("No more keys to try");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response callEndpoint(String endpoint, String query, String location, String postcode, String[] categoryIds, String radius, Integer page, Integer rows) throws Exception {
        String path = endpoint + "?key=" + this.getKey();
        if (query != null) {
            path = path + "&query=" + URLEncoder.encode(Nvl.nvl((String)query), "UTF-8");
        }
        if (location != null) {
            path = path + "&location=" + URLEncoder.encode(location, "UTF-8");
        }
        if (postcode != null) {
            path = path + "&postcode=" + URLEncoder.encode(postcode, "UTF-8");
        }
        path = path + "&sortby=DISTANCE_ALL_PAGES";
        if (page != null) {
            path = path + "&page=" + page;
        }
        if (categoryIds != null) {
            for (String cat : categoryIds) {
                path = path + "&categoryId=" + cat;
            }
        }
        if (rows != null) {
            path = path + "&rows=" + rows;
        }
        if (radius != null) {
            path = path + "&radius=" + radius;
        }
        URL searchUrl = new URL("http://api.sensis.com.au/v1/test/" + path);
        System.out.println("Using " + searchUrl);
        HttpURLConnection conn = (HttpURLConnection)searchUrl.openConnection();
        if (this.lastCall != 0L) {
            long ellapsedSinceLastCall = System.currentTimeMillis() - this.lastCall;
            if (ellapsedSinceLastCall < 1000L) {
                long sleepTime = 1000L - ellapsedSinceLastCall;
                System.out.println("Sleeping for " + sleepTime);
                Thread.sleep(sleepTime);
            } else {
                System.out.println(ellapsedSinceLastCall + " ellapsed so no need to sleep");
            }
        }
        conn.connect();
        this.lastCall = System.currentTimeMillis();
        try {
            if (conn.getResponseCode() != 200) {
                if (conn.getResponseCode() == 403) {
                    System.out.println("Got 403 REMOVING KEY " + this.getKey());
                    this.banKey();
                    Response ellapsedSinceLastCall = null;
                    return ellapsedSinceLastCall;
                }
                throw new RuntimeException("Error calling Search API (HTTP status " + conn.getResponseCode() + ")");
            }
            InputStream stream = conn.getInputStream();
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = (JsonNode)mapper.readValue(stream, JsonNode.class);
            Response response = new Response();
            response.code = root.get("code").getIntValue();
            response.message = root.get("message").getTextValue();
            if (response.message.startsWith("The location") && response.code == 418) {
                Response response2 = response;
                return response2;
            }
            if (response.code != 200 && response.code != 206) {
                throw new RuntimeException("API returned error: " + response.message + ", code: " + response.code);
            }
            response.totalResults = root.get("totalResults").getIntValue();
            for (JsonNode result : root.get("results")) {
                Gson gson = new GsonBuilder().create();
                Contact c = (Contact)gson.fromJson(result.toString(), Contact.class);
                response.results.add(c);
            }
            stream.close();
            Response response3 = response;
            return response3;
        }
        finally {
            conn.disconnect();
        }
    }

    public Response search(String query, String location, String postcode, String[] categoryId, String radius, Integer page, Integer rows) throws Exception {
        while (!this.keys.isEmpty()) {
            Response ret = this.callEndpoint("search", query, location, postcode, categoryId, radius, page, rows);
            if (ret == null) continue;
            return ret;
        }
        System.err.println("No more keys");
        return null;
    }

    public class Response {
        public int code;
        public String message;
        public int totalResults;
        public List<Contact> results = new LinkedList<Contact>();
    }
}

