/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yp.api.sensis.sapi.scraper;

import com.anahata.yp.api.sensis.sapi.scraper.Contact;
import com.anahata.yp.api.sensis.sapi.scraper.ContactListing;
import com.anahata.yp.api.sensis.sapi.scraper.PrimaryAddress;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.apache.commons.lang3.StringEscapeUtils;

public class ContactUtil {
    private static final String COMMA_DELIMITER = ",";
    private static final String NEW_LINE_SEPARATOR = "\n";
    private static final String FILE_HEADER = "id,CompanyName,Email,Phone,Address";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCsvFile(Contact c, String email, String phone, String mobile, String url, String category, String source) {
        String addressLine = "";
        String state = "";
        String type = "";
        String postcode = "";
        String suburb = "";
        String longitude = "";
        String latitude = "";
        PrimaryAddress primaryAddress = c.getPrimaryAddress();
        if (primaryAddress != null) {
            if (primaryAddress.getAddressLine() != null) {
                addressLine = primaryAddress.getAddressLine().contains(COMMA_DELIMITER) ? primaryAddress.getAddressLine().replaceAll(COMMA_DELIMITER, " ") : primaryAddress.getAddressLine();
            }
            if (primaryAddress.getLatitude() != null) {
                latitude = primaryAddress.getLatitude();
            }
            if (primaryAddress.getLongitude() != null) {
                longitude = primaryAddress.getLongitude();
            }
            if (primaryAddress.getPostcode() != null) {
                postcode = primaryAddress.getPostcode();
            }
            if (primaryAddress.getState() != null) {
                state = primaryAddress.getState();
            }
            if (primaryAddress.getSuburb() != null) {
                suburb = primaryAddress.getSuburb();
            }
            if (primaryAddress.getType() != null) {
                type = primaryAddress.getType();
            }
        }
        File f = new File(ContactListing.FILE_NAME);
        OutputStreamWriter fileWriter = null;
        try {
            if (!f.exists() && f.length() == 0L) {
                ContactUtil.writeHeader();
            }
            fileWriter = new FileWriter(ContactListing.FILE_NAME, true);
            fileWriter.append(c.getId());
            fileWriter.append(COMMA_DELIMITER);
            fileWriter.append(ContactUtil.escape(c.getName()));
            fileWriter.append(COMMA_DELIMITER);
            fileWriter.append(c.getBusinessLogo() != null ? c.getBusinessLogo().getUrl() : "");
            fileWriter.append(COMMA_DELIMITER);
            fileWriter.append(ContactUtil.escape(c.getDetailsLink()));
            fileWriter.append(COMMA_DELIMITER);
            fileWriter.append(ContactUtil.escape(c.getListingType()));
            fileWriter.append(COMMA_DELIMITER);
            fileWriter.append(ContactUtil.convert(c.isHasExposureProducts()));
            fileWriter.append(COMMA_DELIMITER);
            fileWriter.append(ContactUtil.convert(c.isPureMobileBusiness()));
            fileWriter.append(COMMA_DELIMITER);
            fileWriter.append(email);
            fileWriter.append(COMMA_DELIMITER);
            fileWriter.append(phone);
            fileWriter.append(COMMA_DELIMITER);
            fileWriter.append(mobile);
            fileWriter.append(COMMA_DELIMITER);
            fileWriter.append(url);
            fileWriter.append(COMMA_DELIMITER);
            fileWriter.append(state);
            fileWriter.append(COMMA_DELIMITER);
            fileWriter.append(suburb);
            fileWriter.append(COMMA_DELIMITER);
            fileWriter.append(postcode);
            fileWriter.append(COMMA_DELIMITER);
            fileWriter.append(ContactUtil.escape(addressLine));
            fileWriter.append(COMMA_DELIMITER);
            fileWriter.append(longitude);
            fileWriter.append(COMMA_DELIMITER);
            fileWriter.append(latitude);
            fileWriter.append(COMMA_DELIMITER);
            fileWriter.append(ContactUtil.escape(category));
            fileWriter.append(COMMA_DELIMITER);
            fileWriter.append(source);
            fileWriter.append(NEW_LINE_SEPARATOR);
        }
        catch (Exception e) {
            System.out.println("Error in CsvFileWriter !!!");
            e.printStackTrace();
        }
        finally {
            try {
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException e) {
                System.out.println("Error while flushing/closing fileWriter !!!");
                e.printStackTrace();
            }
        }
    }

    private static void writeHeader() throws Exception {
        FileWriter fileWriter = new FileWriter(ContactListing.FILE_NAME, true);
        fileWriter.append("Id");
        fileWriter.append(COMMA_DELIMITER);
        fileWriter.append("Account Name");
        fileWriter.append(COMMA_DELIMITER);
        fileWriter.append("Logo");
        fileWriter.append(COMMA_DELIMITER);
        fileWriter.append("DetailsLink");
        fileWriter.append(COMMA_DELIMITER);
        fileWriter.append("ListingType");
        fileWriter.append(COMMA_DELIMITER);
        fileWriter.append("HasExposureProducts");
        fileWriter.append(COMMA_DELIMITER);
        fileWriter.append("PureMobileBusiness");
        fileWriter.append(COMMA_DELIMITER);
        fileWriter.append("Email Address");
        fileWriter.append(COMMA_DELIMITER);
        fileWriter.append("Office Phone");
        fileWriter.append(COMMA_DELIMITER);
        fileWriter.append("Mobile");
        fileWriter.append(COMMA_DELIMITER);
        fileWriter.append("Website");
        fileWriter.append(COMMA_DELIMITER);
        fileWriter.append("Primary Address State");
        fileWriter.append(COMMA_DELIMITER);
        fileWriter.append("Primary Address City");
        fileWriter.append(COMMA_DELIMITER);
        fileWriter.append("Primary Address Postcode");
        fileWriter.append(COMMA_DELIMITER);
        fileWriter.append("Primary Address Postcode");
        fileWriter.append(COMMA_DELIMITER);
        fileWriter.append("Longitude");
        fileWriter.append(COMMA_DELIMITER);
        fileWriter.append("Latitude");
        fileWriter.append(COMMA_DELIMITER);
        fileWriter.append("Category");
        fileWriter.append(COMMA_DELIMITER);
        fileWriter.append("Source");
        fileWriter.append(NEW_LINE_SEPARATOR);
    }

    private static String escape(String value) {
        return StringEscapeUtils.escapeCsv((String)value);
    }

    private static String convert(boolean value) {
        if (value) {
            return "1";
        }
        return "0";
    }
}

