/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yp.api.sensis.sapi.scraper;

import com.anahata.yp.api.sensis.sapi.scraper.Category;
import com.anahata.yp.api.sensis.sapi.scraper.Contact;
import com.anahata.yp.api.sensis.sapi.scraper.ContactUtil;
import com.anahata.yp.api.sensis.sapi.scraper.PrimaryContacts;
import com.anahata.yp.api.sensis.sapi.scraper.SSAPI;
import com.anahata.yp.scrape.Postcodes;
import java.io.File;
import java.util.Objects;
import java.util.Set;

public class ContactListing {
    private static final int ROW_COUNT = 50;
    public static final String FILE_NAME = System.getProperty("user.home") + File.separator + "IT other-states.csv";

    private int printResults(SSAPI.Response response, String postcode) {
        int correctPostCode = 0;
        for (Contact c : response.results) {
            if (c.getPrimaryAddress() == null || !Objects.equals(c.getPrimaryAddress().getPostcode(), postcode)) break;
            ++correctPostCode;
            String email = "";
            String phone = "";
            String mobile = "";
            String url = "";
            String category = "";
            for (PrimaryContacts cc : c.getPrimaryContacts()) {
                if (cc.getType().equals("PHONE")) {
                    phone = cc.getValue();
                } else if (cc.getType().equals("MOBILE")) {
                    mobile = cc.getValue();
                } else if (cc.getType().equals("EMAIL")) {
                    email = cc.getValue();
                } else if (cc.getType().equals("URL")) {
                    url = cc.getValue();
                }
                System.out.println(cc);
            }
            for (Category cat : c.getCategories()) {
                if (cat.getName() == null || cat.getName().isEmpty()) continue;
                String name = cat.getName();
                if (name.contains(",")) {
                    category = name.replaceAll(",", " ");
                    break;
                }
                category = name;
                break;
            }
            ContactUtil.writeCsvFile(c, email, phone, mobile, url, category, "YPO");
        }
        return correctPostCode;
    }

    public void generateCSVFile() throws Exception {
        SSAPI ssapi = new SSAPI();
        Set<String> postcodes = Postcodes.postcodes;
        String[] categories = new String[]{"44385", "42811", "41750", "29025", "24457", "39993", "39985", "41483", "45101", "19461", "43389", "39977", "22268", "19038", "6015", "45128"};
        String resumePostcode = "1041";
        block0: for (String postcode : postcodes) {
            if (postcode.startsWith("2") || postcode.startsWith("3") || postcode.startsWith("6")) continue;
            if (resumePostcode != null) {
                if (!postcode.equals(resumePostcode)) {
                    System.out.println("Skipping " + postcode);
                    continue;
                }
                System.out.println("Resuming on " + postcode);
                resumePostcode = null;
            }
            int page = 1;
            System.out.println("--- Starting postcode " + postcode + " ");
            int fetchedOnThisPostcode = 0;
            while (true) {
                SSAPI.Response response;
                if ((response = ssapi.search("IT", postcode, postcode, categories, null, page, 50)) == null) {
                    System.out.println("All keys exhaused. Calling System.exit(-1)");
                    System.exit(-1);
                }
                int records = this.printResults(response, postcode);
                System.out.println("fetched " + (fetchedOnThisPostcode += records) + " / " + response.totalResults);
                if (records < response.results.size()) {
                    System.out.println(postcode + " Got to other postcodes on : " + page + " with " + fetchedOnThisPostcode + " /" + response.totalResults);
                    continue block0;
                }
                if (records < 50) {
                    System.out.println(postcode + "Got to last page: " + page + " with " + fetchedOnThisPostcode + " /" + response.totalResults);
                    continue block0;
                }
                if (fetchedOnThisPostcode >= response.totalResults) {
                    System.out.println(postcode + " All results fetched, stopping " + page + " with " + fetchedOnThisPostcode + " /" + response.totalResults);
                    continue block0;
                }
                if (fetchedOnThisPostcode >= 1000) {
                    System.err.println(postcode + " Got 1000. postcode has unfetched results. " + page + " with " + fetchedOnThisPostcode + " /" + response.totalResults);
                }
                ++page;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new ContactListing().generateCSVFile();
    }
}

