/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yp.api.sensis.sapi.responsemodel;

import com.anahata.yp.api.sensis.sapi.responsemodel.AddressType;
import com.anahata.yp.api.sensis.sapi.responsemodel.Granularity;
import com.anahata.yp.api.sensis.sapi.responsemodel.StreetAddress;

public class Address {
    public static final String KEY_TYPE = "type";
    public static final String KEY_ADDRESS_LINE = "addressLine";
    public static final String KEY_EMS_FRIENDLY_ADDRESS = "emsFriendlyAddress";
    public static final String KEY_SUBURB = "suburb";
    public static final String KEY_STATE = "state";
    public static final String KEY_POSTCODE = "postcode";
    public static final String KEY_LATITUDE = "latitude";
    public static final String KEY_LONGITUDE = "longitude";
    public static final String KEY_IS_GEOCODABLE = "isGeocodable";
    public static final String KEY_GRANULARITY = "geoCodeGranularity";
    private AddressType type;
    private String addressLine;
    private String suburb;
    private String state;
    private String postcode;
    private String latitude;
    private String longitude;
    private Granularity geoCodeGranularity = Granularity.NOT_FOUND;
    private StreetAddress streetAddress;

    public Address(AddressType type, String addressLine, String suburb, String state, String postcode, String latitude, String longitude, Granularity geoCodeGranularity) {
        this.type = type;
        this.addressLine = addressLine;
        this.suburb = suburb;
        this.state = state;
        this.postcode = postcode;
        this.latitude = latitude;
        this.longitude = longitude;
        this.geoCodeGranularity = geoCodeGranularity;
    }

    public Address(AddressType type, String addressLine, String suburb, String state, String postcode) {
        this(type, addressLine, suburb, state, postcode, null, null, null);
    }

    public Address(Address address) {
        this.type = address.getType();
        this.addressLine = address.getAddressLine();
        this.suburb = address.getSuburb();
        this.state = address.getState();
        this.postcode = address.getPostcode();
        this.latitude = address.getLatitude();
        this.longitude = address.getLongitude();
        this.geoCodeGranularity = Granularity.findByName(address.getGeoCodeGranularity());
    }

    public Address() {
    }

    public AddressType getType() {
        return this.type;
    }

    public void setType(AddressType type) {
        this.type = type;
    }

    public String getAddressLine() {
        return this.addressLine;
    }

    public void setAddressLine(String addressLine) {
        this.addressLine = addressLine;
    }

    public String getSuburb() {
        return this.suburb;
    }

    public void setSuburb(String suburb) {
        this.suburb = suburb;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getPostcode() {
        return this.postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String addressAsString() {
        StringBuilder builder = new StringBuilder();
        if (this.addressLine != null) {
            builder.append(this.addressLine);
            builder.append("\n");
        }
        if (this.suburb != null) {
            builder.append(this.suburb);
            builder.append("\n");
        }
        if (this.state != null) {
            builder.append(this.state);
            builder.append(" ");
            builder.append(this.postcode);
        }
        return builder.toString();
    }

    public String getGeoCodeGranularity() {
        return this.geoCodeGranularity == null || Granularity.NOT_FOUND.equals((Object)this.geoCodeGranularity) ? null : this.geoCodeGranularity.name();
    }

    public void setGeoCodeGranularity(Granularity geoCodeGranularity) {
        this.geoCodeGranularity = geoCodeGranularity;
    }

    public StreetAddress getStreetAddress() {
        return this.streetAddress;
    }

    public void setStreetAddress(StreetAddress streetAddress) {
        this.streetAddress = streetAddress;
    }
}

