/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yp.api.sensis.sapi.client;

import com.anahata.yp.api.sensis.sapi.client.MetadataType;
import com.anahata.yp.api.sensis.sapi.client.SapiEnvironment;
import com.anahata.yp.api.sensis.sapi.requestmodel.ReportingEvent;
import com.anahata.yp.api.sensis.sapi.requestmodel.SearchParams;
import com.anahata.yp.api.sensis.sapi.responsemodel.MetadataResponse;
import com.anahata.yp.api.sensis.sapi.responsemodel.ReportReponse;
import com.anahata.yp.api.sensis.sapi.responsemodel.SearchResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;

public class SapiClient {
    public static final String SAPI_HOST = "api.sensis.com.au";
    public static final int SAPI_PORT = 80;
    public static final String SEARCH_PATH_TEMPLATE = "/ob-20110511/%s/search";
    public static final String REPORT_PATH_TEMPLATE = "/ob-20110511/%s/report";
    private static final String GET_BY_LISTING_ID_PATH_TEMPLATE = "/ob-20110511/%s/getByListingId";
    private static final String METADATA_PATH_TEMPLATE = "/ob-20110511/%s/metadata";
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final String apiKey;
    private final String searchPath;
    private final String reportPath;
    private final String getByListingIdPath;
    private final String metadataPath;
    private String proxyUrl;
    private int proxyPort;

    public SapiClient(String apiKey, SapiEnvironment environment) {
        this.apiKey = apiKey;
        this.searchPath = String.format(SEARCH_PATH_TEMPLATE, environment.toString());
        this.reportPath = String.format(REPORT_PATH_TEMPLATE, environment.toString());
        this.getByListingIdPath = String.format(GET_BY_LISTING_ID_PATH_TEMPLATE, environment.toString());
        this.metadataPath = String.format(METADATA_PATH_TEMPLATE, environment.toString());
    }

    public SearchResponse search(SearchParams params) {
        URI uri = null;
        String jsonResponse = null;
        try {
            HttpClient client = this.getHttpClient();
            ArrayList<BasicNameValuePair> queryParams = new ArrayList<BasicNameValuePair>();
            this.addQueryParam(queryParams, "key", this.apiKey);
            this.addQueryParam(queryParams, "query", params.getQuery());
            this.addQueryParam(queryParams, "location", params.getLocation());
            this.addQueryParam(queryParams, "sortBy", (Object)params.getSortBy());
            this.addQueryParam(queryParams, "page", params.getPage());
            this.addQueryParam(queryParams, "rows", params.getRows());
            this.addQueryParam(queryParams, "sensitiveCategories", params.getSensitiveCategories());
            this.addQueryParam(queryParams, "radius", params.getRadius());
            this.addQueryParam(queryParams, "locationTiers", params.getLocationTiers());
            this.addQueryParam(queryParams, "boundingBox", params.getBoundingBox());
            this.addQueryParams(queryParams, "categoryId", params.getCategoryIds());
            this.addQueryParams(queryParams, "postcode", params.getPostcodes());
            this.addQueryParams(queryParams, "suburb", params.getSuburbs());
            this.addQueryParams(queryParams, "state", params.getStates());
            this.addQueryParams(queryParams, "content", params.getContentFilters());
            this.addQueryParams(queryParams, "productKeyword", params.getProductKeywords());
            uri = URIUtils.createURI((String)"http", (String)SAPI_HOST, (int)80, (String)this.searchPath, (String)URLEncodedUtils.format(queryParams, (String)"UTF-8"), null);
            HttpResponse httpResponse = client.execute((HttpUriRequest)new HttpGet(uri));
            jsonResponse = this.extractJsonResponse(httpResponse);
            SearchResponse searchResponse = (SearchResponse)OBJECT_MAPPER.readValue(jsonResponse, SearchResponse.class);
            return searchResponse;
        }
        catch (Exception e) {
            throw this.wrapException(uri, jsonResponse, e);
        }
    }

    public SearchResponse getByListingId(String listingId) {
        URI uri = null;
        String jsonResponse = null;
        try {
            HttpClient client = this.getHttpClient();
            ArrayList<BasicNameValuePair> queryParams = new ArrayList<BasicNameValuePair>();
            this.addQueryParam(queryParams, "key", this.apiKey);
            this.addQueryParam(queryParams, "query", listingId);
            uri = URIUtils.createURI((String)"http", (String)SAPI_HOST, (int)80, (String)this.getByListingIdPath, (String)URLEncodedUtils.format(queryParams, (String)"UTF-8"), null);
            HttpResponse httpResponse = client.execute((HttpUriRequest)new HttpGet(uri));
            jsonResponse = this.extractJsonResponse(httpResponse);
            SearchResponse searchResponse = (SearchResponse)OBJECT_MAPPER.readValue(jsonResponse, SearchResponse.class);
            return searchResponse;
        }
        catch (Exception e) {
            throw this.wrapException(uri, jsonResponse, e);
        }
    }

    public MetadataResponse metadata(MetadataType dataType) {
        URI uri = null;
        String jsonResponse = null;
        try {
            HttpClient client = this.getHttpClient();
            ArrayList<BasicNameValuePair> queryParams = new ArrayList<BasicNameValuePair>();
            this.addQueryParam(queryParams, "key", this.apiKey);
            uri = URIUtils.createURI((String)"http", (String)SAPI_HOST, (int)80, (String)(this.metadataPath + "/" + dataType.toString()), (String)URLEncodedUtils.format(queryParams, (String)"UTF-8"), null);
            HttpResponse httpResponse = client.execute((HttpUriRequest)new HttpGet(uri));
            jsonResponse = this.extractJsonResponse(httpResponse);
            MetadataResponse searchResponse = (MetadataResponse)OBJECT_MAPPER.readValue(jsonResponse, MetadataResponse.class);
            return searchResponse;
        }
        catch (Exception e) {
            throw this.wrapException(uri, jsonResponse, e);
        }
    }

    public ReportReponse report(ReportingEvent reportEvent, String userIp, String userAgent, String userSessionId, String content, String reportingId, String ... additionalReportingIds) {
        URI uri = null;
        String jsonResponse = null;
        try {
            HttpClient client = this.getHttpClient();
            ArrayList<BasicNameValuePair> queryParams = new ArrayList<BasicNameValuePair>();
            this.addQueryParam(queryParams, "key", this.apiKey);
            this.addQueryParam(queryParams, "userIp", userIp);
            this.addQueryParam(queryParams, "userAgent", userAgent);
            this.addQueryParam(queryParams, "userSessionId", userSessionId);
            this.addQueryParam(queryParams, "content", content);
            this.addQueryParam(queryParams, "id", reportingId);
            this.addQueryParams(queryParams, "id", Arrays.asList(additionalReportingIds));
            uri = URIUtils.createURI((String)"http", (String)SAPI_HOST, (int)80, (String)(this.reportPath + "/" + reportEvent.toString()), (String)URLEncodedUtils.format(queryParams, (String)"UTF-8"), null);
            HttpGet request = new HttpGet(uri);
            HttpResponse httpResponse = client.execute((HttpUriRequest)request);
            jsonResponse = this.extractJsonResponse(httpResponse);
            ReportReponse reportResponse = (ReportReponse)OBJECT_MAPPER.readValue(jsonResponse, ReportReponse.class);
            return reportResponse;
        }
        catch (Exception e) {
            throw this.wrapException(uri, jsonResponse, e);
        }
    }

    public void setProxy(String proxyUrl, int port) {
        this.proxyUrl = proxyUrl;
        this.proxyPort = port;
    }

    private HttpClient getHttpClient() {
        DefaultHttpClient client = new DefaultHttpClient((HttpParams)new BasicHttpParams());
        if (this.proxyUrl != null) {
            HttpHost proxyHost = new HttpHost(this.proxyUrl, this.proxyPort);
            client.getParams().setParameter("http.route.default-proxy", (Object)proxyHost);
        }
        return client;
    }

    private String extractJsonResponse(HttpResponse httpResponse) throws IOException {
        String jsonResponse = "";
        BufferedReader rd = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));
        String line = "";
        while ((line = rd.readLine()) != null) {
            jsonResponse = jsonResponse + line;
        }
        return jsonResponse;
    }

    private void addQueryParam(List<BasicNameValuePair> builder, String key, Object value) {
        if (value != null) {
            builder.add(new BasicNameValuePair(key, value.toString()));
        }
    }

    private void addQueryParams(List<BasicNameValuePair> builder, String key, List<?> values) {
        if (values != null && !values.isEmpty()) {
            for (Object value : values) {
                if (value == null) continue;
                builder.add(new BasicNameValuePair(key, value.toString()));
            }
        }
    }

    private RuntimeException wrapException(URI uri, String jsonResponse, Exception e) {
        String errorMessage = "";
        errorMessage = jsonResponse != null ? "Successfully called SAPI, but could not parse response: " + jsonResponse : "Could not successfully call SAPI with url " + uri + " due to exception";
        return new RuntimeException(errorMessage, e);
    }

    static {
        OBJECT_MAPPER.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

