/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.sugarcrm.model;

import com.anahata.sugarcrm.model.ProspectCustom;
import com.anahata.sugarcrm.model.ProspectEmail;
import com.anahata.sugarcrm.model.ProspectEmailAddress;
import com.anahata.sugarcrm.model.ProspectNote;
import com.anahata.sugarcrm.model.Utils;
import com.anahata.util.lang.Nvl;
import com.anahata.util.lang.builder.DelimitedStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="prospects")
public class Prospect
implements Serializable {
    @Id
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=36)
    @Column(name="id")
    private String id;
    @Column(name="date_entered")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateEntered;
    @Column(name="date_modified")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateModified;
    @Size(max=36)
    @Column(name="modified_user_id")
    private String modifiedUserId;
    @Size(max=36)
    @Column(name="created_by")
    private String createdBy;
    @Lob
    @Size(max=65535)
    @Column(name="description")
    private String description;
    @Column(name="deleted")
    private Boolean deleted;
    @Size(max=36)
    @Column(name="assigned_user_id")
    private String assignedUserId;
    @Size(max=255)
    @Column(name="salutation")
    private String salutation;
    @Size(max=100)
    @Column(name="first_name")
    private String firstName;
    @Size(max=100)
    @Column(name="last_name")
    private String lastName;
    @Size(max=100)
    @Column(name="title")
    private String title;
    @Size(max=255)
    @Column(name="department")
    private String department;
    @Column(name="do_not_call")
    private Boolean doNotCall;
    @Size(max=100)
    @Column(name="phone_home")
    private String phoneHome;
    @Size(max=100)
    @Column(name="phone_mobile")
    private String phoneMobile;
    @Size(max=100)
    @Column(name="phone_work")
    private String phoneWork;
    @Size(max=100)
    @Column(name="phone_other")
    private String phoneOther;
    @Size(max=100)
    @Column(name="phone_fax")
    private String phoneFax;
    @Size(max=150)
    @Column(name="primary_address_street")
    private String primaryAddressStreet;
    @Size(max=100)
    @Column(name="primary_address_city")
    private String primaryAddressCity;
    @Size(max=100)
    @Column(name="primary_address_state")
    private String primaryAddressState;
    @Size(max=20)
    @Column(name="primary_address_postalcode")
    private String primaryAddressPostalcode;
    @Size(max=255)
    @Column(name="primary_address_country")
    private String primaryAddressCountry;
    @Size(max=150)
    @Column(name="alt_address_street")
    private String altAddressStreet;
    @Size(max=100)
    @Column(name="alt_address_city")
    private String altAddressCity;
    @Size(max=100)
    @Column(name="alt_address_state")
    private String altAddressState;
    @Size(max=20)
    @Column(name="alt_address_postalcode")
    private String altAddressPostalcode;
    @Size(max=255)
    @Column(name="alt_address_country")
    private String altAddressCountry;
    @Size(max=75)
    @Column(name="assistant")
    private String assistant;
    @Size(max=100)
    @Column(name="assistant_phone")
    private String assistantPhone;
    @Basic(optional=false)
    @Column(name="tracker_key")
    private int trackerKey;
    @Column(name="birthdate")
    @Temporal(value=TemporalType.DATE)
    private Date birthdate;
    @Size(max=36)
    @Column(name="lead_id")
    private String leadId;
    @Size(max=150)
    @Column(name="account_name")
    private String accountName;
    @Size(max=36)
    @Column(name="campaign_id")
    private String campaignId;
    @OneToOne(mappedBy="prospect", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private ProspectCustom custom;
    @OneToMany(mappedBy="prospect", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private List<ProspectNote> notes = new ArrayList<ProspectNote>();
    @OneToMany(mappedBy="prospect", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private List<ProspectEmail> sentEmails = new ArrayList<ProspectEmail>();
    @OneToMany(mappedBy="prospect", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private List<ProspectEmailAddress> emailAddresses = new ArrayList<ProspectEmailAddress>();

    public String getEmailAddress() {
        for (ProspectEmailAddress pea : this.emailAddresses) {
            if (pea.getEmailAddress().getDeleted() != null && pea.getEmailAddress().getDeleted().booleanValue()) continue;
            return pea.getEmailAddress().getEmailAddress();
        }
        return null;
    }

    public String getPhonesDisplay() {
        DelimitedStringBuilder dsb = new DelimitedStringBuilder(" / ");
        if (!StringUtils.isBlank((CharSequence)this.phoneWork)) {
            dsb.append(this.phoneWork);
        }
        if (!StringUtils.isBlank((CharSequence)this.phoneMobile) && !dsb.toString().contains(Nvl.nvl((String)this.phoneMobile))) {
            dsb.append(this.phoneMobile);
        }
        if (!StringUtils.isBlank((CharSequence)this.phoneOther) && !dsb.toString().contains(Nvl.nvl((String)this.phoneOther))) {
            dsb.append(this.phoneOther);
        }
        return dsb.toString();
    }

    public double getDistanceTo(double lat, double lon) {
        try {
            double thisLat = Double.parseDouble(this.custom.getLatitude());
            double thisLon = Double.parseDouble(this.custom.getLongitude());
            return Utils.pointToPointDistance(lat, lon, thisLat, thisLon, "K");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Could not calculate distance for " + this.accountName + " lat=" + this.custom.getLatitude() + " lon=" + this.custom.getLongitude());
            return Double.MAX_VALUE;
        }
    }

    public String getAddressDisplay() {
        String street = Nvl.nvl((String)this.getPrimaryAddressStreet()).trim();
        if (!street.isEmpty()) {
            street = street + ", ";
        }
        String ret = street + Nvl.nvl((String)this.getPrimaryAddressCity()) + " " + Nvl.nvl((String)this.getPrimaryAddressState()) + " " + Nvl.nvl((String)this.getPrimaryAddressPostalcode());
        return ret;
    }

    public String getId() {
        return this.id;
    }

    public Date getDateEntered() {
        return this.dateEntered;
    }

    public Date getDateModified() {
        return this.dateModified;
    }

    public String getModifiedUserId() {
        return this.modifiedUserId;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public String getAssignedUserId() {
        return this.assignedUserId;
    }

    public String getSalutation() {
        return this.salutation;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDepartment() {
        return this.department;
    }

    public Boolean getDoNotCall() {
        return this.doNotCall;
    }

    public String getPhoneHome() {
        return this.phoneHome;
    }

    public String getPhoneMobile() {
        return this.phoneMobile;
    }

    public String getPhoneWork() {
        return this.phoneWork;
    }

    public String getPhoneOther() {
        return this.phoneOther;
    }

    public String getPhoneFax() {
        return this.phoneFax;
    }

    public String getPrimaryAddressStreet() {
        return this.primaryAddressStreet;
    }

    public String getPrimaryAddressCity() {
        return this.primaryAddressCity;
    }

    public String getPrimaryAddressState() {
        return this.primaryAddressState;
    }

    public String getPrimaryAddressPostalcode() {
        return this.primaryAddressPostalcode;
    }

    public String getPrimaryAddressCountry() {
        return this.primaryAddressCountry;
    }

    public String getAltAddressStreet() {
        return this.altAddressStreet;
    }

    public String getAltAddressCity() {
        return this.altAddressCity;
    }

    public String getAltAddressState() {
        return this.altAddressState;
    }

    public String getAltAddressPostalcode() {
        return this.altAddressPostalcode;
    }

    public String getAltAddressCountry() {
        return this.altAddressCountry;
    }

    public String getAssistant() {
        return this.assistant;
    }

    public String getAssistantPhone() {
        return this.assistantPhone;
    }

    public int getTrackerKey() {
        return this.trackerKey;
    }

    public Date getBirthdate() {
        return this.birthdate;
    }

    public String getLeadId() {
        return this.leadId;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public ProspectCustom getCustom() {
        return this.custom;
    }

    public List<ProspectNote> getNotes() {
        return this.notes;
    }

    public List<ProspectEmail> getSentEmails() {
        return this.sentEmails;
    }

    public List<ProspectEmailAddress> getEmailAddresses() {
        return this.emailAddresses;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDateEntered(Date dateEntered) {
        this.dateEntered = dateEntered;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public void setModifiedUserId(String modifiedUserId) {
        this.modifiedUserId = modifiedUserId;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public void setAssignedUserId(String assignedUserId) {
        this.assignedUserId = assignedUserId;
    }

    public void setSalutation(String salutation) {
        this.salutation = salutation;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public void setDoNotCall(Boolean doNotCall) {
        this.doNotCall = doNotCall;
    }

    public void setPhoneHome(String phoneHome) {
        this.phoneHome = phoneHome;
    }

    public void setPhoneMobile(String phoneMobile) {
        this.phoneMobile = phoneMobile;
    }

    public void setPhoneWork(String phoneWork) {
        this.phoneWork = phoneWork;
    }

    public void setPhoneOther(String phoneOther) {
        this.phoneOther = phoneOther;
    }

    public void setPhoneFax(String phoneFax) {
        this.phoneFax = phoneFax;
    }

    public void setPrimaryAddressStreet(String primaryAddressStreet) {
        this.primaryAddressStreet = primaryAddressStreet;
    }

    public void setPrimaryAddressCity(String primaryAddressCity) {
        this.primaryAddressCity = primaryAddressCity;
    }

    public void setPrimaryAddressState(String primaryAddressState) {
        this.primaryAddressState = primaryAddressState;
    }

    public void setPrimaryAddressPostalcode(String primaryAddressPostalcode) {
        this.primaryAddressPostalcode = primaryAddressPostalcode;
    }

    public void setPrimaryAddressCountry(String primaryAddressCountry) {
        this.primaryAddressCountry = primaryAddressCountry;
    }

    public void setAltAddressStreet(String altAddressStreet) {
        this.altAddressStreet = altAddressStreet;
    }

    public void setAltAddressCity(String altAddressCity) {
        this.altAddressCity = altAddressCity;
    }

    public void setAltAddressState(String altAddressState) {
        this.altAddressState = altAddressState;
    }

    public void setAltAddressPostalcode(String altAddressPostalcode) {
        this.altAddressPostalcode = altAddressPostalcode;
    }

    public void setAltAddressCountry(String altAddressCountry) {
        this.altAddressCountry = altAddressCountry;
    }

    public void setAssistant(String assistant) {
        this.assistant = assistant;
    }

    public void setAssistantPhone(String assistantPhone) {
        this.assistantPhone = assistantPhone;
    }

    public void setTrackerKey(int trackerKey) {
        this.trackerKey = trackerKey;
    }

    public void setBirthdate(Date birthdate) {
        this.birthdate = birthdate;
    }

    public void setLeadId(String leadId) {
        this.leadId = leadId;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public void setCustom(ProspectCustom custom) {
        this.custom = custom;
    }

    public void setNotes(List<ProspectNote> notes) {
        this.notes = notes;
    }

    public void setSentEmails(List<ProspectEmail> sentEmails) {
        this.sentEmails = sentEmails;
    }

    public void setEmailAddresses(List<ProspectEmailAddress> emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Prospect)) {
            return false;
        }
        Prospect other = (Prospect)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Prospect;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

