/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.sugarcrm.model;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="parent_type")
@Table(name="notes")
public abstract class Note
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=36)
    @Column(name="id")
    private String id = UUID.randomUUID().toString();
    @Size(max=36)
    @Column(name="assigned_user_id")
    private String assignedUserId;
    @Column(name="date_entered")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateEntered = new Date();
    @Column(name="date_modified")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateModified = new Date();
    @Size(max=36)
    @Column(name="modified_user_id")
    private String modifiedUserId = "1";
    @Size(max=36)
    @Column(name="created_by")
    private String createdBy = "1";
    @Size(max=255)
    @Column(name="name")
    private String name;
    @Size(max=100)
    @Column(name="file_mime_type")
    private String fileMimeType;
    @Size(max=255)
    @Column(name="filename")
    private String filename;
    @Size(max=36)
    @Column(name="contact_id")
    private String contactId;
    @Column(name="portal_flag")
    private Boolean portalFlag = false;
    @Column(name="embed_flag")
    private Boolean embedFlag = false;
    @Lob
    @Size(max=65535)
    @Column(name="description")
    private String description;
    @Column(name="deleted")
    private Boolean deleted = false;

    public String getId() {
        return this.id;
    }

    public String getAssignedUserId() {
        return this.assignedUserId;
    }

    public Date getDateEntered() {
        return this.dateEntered;
    }

    public Date getDateModified() {
        return this.dateModified;
    }

    public String getModifiedUserId() {
        return this.modifiedUserId;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getName() {
        return this.name;
    }

    public String getFileMimeType() {
        return this.fileMimeType;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContactId() {
        return this.contactId;
    }

    public Boolean getPortalFlag() {
        return this.portalFlag;
    }

    public Boolean getEmbedFlag() {
        return this.embedFlag;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAssignedUserId(String assignedUserId) {
        this.assignedUserId = assignedUserId;
    }

    public void setDateEntered(Date dateEntered) {
        this.dateEntered = dateEntered;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public void setModifiedUserId(String modifiedUserId) {
        this.modifiedUserId = modifiedUserId;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFileMimeType(String fileMimeType) {
        this.fileMimeType = fileMimeType;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setContactId(String contactId) {
        this.contactId = contactId;
    }

    public void setPortalFlag(Boolean portalFlag) {
        this.portalFlag = portalFlag;
    }

    public void setEmbedFlag(Boolean embedFlag) {
        this.embedFlag = embedFlag;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Note)) {
            return false;
        }
        Note other = (Note)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Note;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

