/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.sugarcrm.model;

import com.anahata.sugarcrm.model.EmailNote;
import com.anahata.sugarcrm.model.EmailRecipient;
import com.anahata.sugarcrm.model.EmailText;
import com.anahata.util.lang.builder.DelimitedStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="emails")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="parent_type")
public class AbstractEmail
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=36)
    private String id = UUID.randomUUID().toString();
    @Column(name="date_entered")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateEntered = new Date();
    @Column(name="date_modified")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateModified = new Date();
    @Size(max=36)
    @Column(name="assigned_user_id")
    private String assignedUserId = "1";
    @Size(max=36)
    @Column(name="modified_user_id")
    private String modifiedUserId = "1";
    @Size(max=36)
    @Column(name="created_by")
    private String createdBy = "1";
    private Boolean deleted = false;
    @Column(name="date_sent")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateSent = new Date();
    @Size(max=255)
    @Column(name="message_id")
    private String messageId;
    @Size(max=255)
    @Column(name="name")
    private String subject;
    @Size(max=100)
    private String type = "out";
    @Size(max=100)
    private String status = "sent";
    private Boolean flagged;
    @Column(name="reply_to_status")
    private Boolean replyToStatus;
    @Size(max=100)
    private String intent = "pick";
    @Size(max=36)
    @Column(name="mailbox_id")
    private String mailboxId;
    @OneToMany(mappedBy="email", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private List<EmailNote> notes = new ArrayList<EmailNote>();
    @OneToMany(mappedBy="email", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private List<EmailRecipient> recipients = new ArrayList<EmailRecipient>();
    @OneToOne(mappedBy="email", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private EmailText text;

    public String getAllEmailIdsSentTo() {
        DelimitedStringBuilder dsb = new DelimitedStringBuilder(", ");
        for (EmailRecipient recipient : this.recipients) {
            dsb.append(recipient.getEmailAddress().getEmailAddress());
        }
        return dsb.toString();
    }

    public String getId() {
        return this.id;
    }

    public Date getDateEntered() {
        return this.dateEntered;
    }

    public Date getDateModified() {
        return this.dateModified;
    }

    public String getAssignedUserId() {
        return this.assignedUserId;
    }

    public String getModifiedUserId() {
        return this.modifiedUserId;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public Date getDateSent() {
        return this.dateSent;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getType() {
        return this.type;
    }

    public String getStatus() {
        return this.status;
    }

    public Boolean getFlagged() {
        return this.flagged;
    }

    public Boolean getReplyToStatus() {
        return this.replyToStatus;
    }

    public String getIntent() {
        return this.intent;
    }

    public String getMailboxId() {
        return this.mailboxId;
    }

    public List<EmailNote> getNotes() {
        return this.notes;
    }

    public List<EmailRecipient> getRecipients() {
        return this.recipients;
    }

    public EmailText getText() {
        return this.text;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDateEntered(Date dateEntered) {
        this.dateEntered = dateEntered;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public void setAssignedUserId(String assignedUserId) {
        this.assignedUserId = assignedUserId;
    }

    public void setModifiedUserId(String modifiedUserId) {
        this.modifiedUserId = modifiedUserId;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public void setDateSent(Date dateSent) {
        this.dateSent = dateSent;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setFlagged(Boolean flagged) {
        this.flagged = flagged;
    }

    public void setReplyToStatus(Boolean replyToStatus) {
        this.replyToStatus = replyToStatus;
    }

    public void setIntent(String intent) {
        this.intent = intent;
    }

    public void setMailboxId(String mailboxId) {
        this.mailboxId = mailboxId;
    }

    public void setNotes(List<EmailNote> notes) {
        this.notes = notes;
    }

    public void setRecipients(List<EmailRecipient> recipients) {
        this.recipients = recipients;
    }

    public void setText(EmailText text) {
        this.text = text;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractEmail)) {
            return false;
        }
        AbstractEmail other = (AbstractEmail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractEmail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

