/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.sugarcrm.jpa;

import com.anahata.scp.Scp;
import com.anahata.sugarcrm.jpa.AbstractMigrator;
import com.anahata.sugarcrm.jpa.SpamKeywords;
import com.anahata.sugarcrm.model.EmailAddress;
import com.anahata.sugarcrm.model.EmailNote;
import com.anahata.sugarcrm.model.EmailRecipient;
import com.anahata.sugarcrm.model.EmailText;
import com.anahata.sugarcrm.model.Prospect;
import com.anahata.sugarcrm.model.ProspectEmail;
import com.anahata.util.cdi.Cdi;
import com.anahata.util.compress.ZipUtils;
import com.anahata.util.email.ByteArrayAttachment;
import com.anahata.util.email.Email;
import com.anahata.util.email.OutgoingEmailService;
import com.anahata.util.io.AnahataFileUtils;
import com.anahata.util.lang.Nvl;
import com.anahata.yp.docmosis.HtmlDocumentPostProcessor;
import com.anahata.yp.props.Config;
import com.docmosis.SystemManager;
import com.docmosis.document.DocumentProcessor;
import com.docmosis.document.RenderRequest;
import com.docmosis.document.converter.ConversionFormat;
import com.docmosis.document.converter.ConversionInstruction;
import com.docmosis.template.population.DataProviderBuilder;
import com.smsglobal.client.Client;
import com.smsglobal.client.Message;
import com.smsglobal.transport.HttpTransport;
import java.awt.Desktop;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailSender
extends AbstractMigrator {
    private static final Logger log = LoggerFactory.getLogger(EmailSender.class);
    private static boolean REAL;
    @Inject
    private Config config;
    private OutgoingEmailService emailService;
    private Scp scp = new Scp("p.anahata.uno", 10008, "admin", "Yog1Bear08");
    private static final String SUBJECT_IT_REFERRAL_NEAR = "Can I come around tomorrow?";
    private static final String SUBJECT_IT_REFERRAL_FAR = "Proposal document for general manager";
    private static final String CAMPAIGN_CODE = "IT";
    private static final String STATE = "VIC";
    private static final String NOTE_NAME = "IT-BPP-1";

    public EmailSender() {
        super(new String[0]);
    }

    @PostConstruct
    private void init() {
        this.emailService = new OutgoingEmailService(this.config.getOutgoingEmailConfig());
    }

    @Override
    public void migrate() throws Exception {
        String query0 = "Select p.id, p.phoneMobile From Prospect p  JOIN p.emailAddresses pea  WHERE p.custom.campaignCode = :campaignCode  AND UPPER(p.custom.category) LIKE '%COMPUTER%' AND p.leadId = null AND pea.deleted = false AND p.primaryAddressState = :state  AND p.phoneMobile is not null AND p.phoneMobile <> '' AND EXISTS      (SELECT pe FROM ProspectEmail pe          JOIN pe.recipients rec         JOIN pe.notes note         WHERE pe.prospect = p         AND UPPER(rec.emailAddress.emailAddress) = UPPER(pea.emailAddress.emailAddress)         AND UPPER(note.name) = UPPER(:note)         AND note.deleted = false       ) Order by p.primaryAddressPostalcode ASC";
        List prospects = this.targetEm.createQuery(query0).setParameter("campaignCode", (Object)CAMPAIGN_CODE).setParameter("state", (Object)STATE).setParameter("note", (Object)NOTE_NAME).getResultList();
        File emailBodyTemplate = new File(this.getClass().getResource("/templates/emailbody.odt").toURI());
        File attachmentTemplate = new File(this.getClass().getResource("/templates/ITProposal.odt").toURI());
        for (Object[] data : prospects) {
            System.out.println(data[1] + " http://crm.anahata.uno/?action=ajaxui#ajaxUILoc=index.php%3Fmodule%3DProspects%26offset%3D1%26stamp%3D1477387855046425000%26return_module%3DProspects%26action%3DDetailView%26record%3D" + data[0]);
        }
        System.out.println("total " + prospects.size());
        for (Object[] data : prospects) {
            Prospect p = (Prospect)data[0];
            EmailAddress ea = (EmailAddress)data[1];
            System.out.println("Propsect " + p.getAccountName() + " ea=" + ea.getEmailAddress() + " " + p.getCustom().getCategory() + " pc=" + p.getPrimaryAddressPostalcode() + " " + p.getCustom().getWebsite());
        }
        System.out.println("Total prospects " + prospects.size());
    }

    private void sendEmail(Prospect p, EmailAddress ea, File emailBodyTemplate, File attachmentTemplate, DocumentModel documentModel) throws Exception {
        boolean addressPresent;
        String fileName = p.getAccountName() + "-Anahata-Proposal";
        fileName = fileName.replaceAll("[^A-Za-z0-9]", "_");
        fileName = fileName.replaceAll("[^A-Za-z0-9]", "_");
        fileName = fileName.replaceAll("__", "_");
        fileName = fileName.replaceAll("__", "_");
        fileName = fileName.replaceAll("__", "_");
        fileName = fileName.replaceAll("__", "_");
        fileName = fileName + ".pdf";
        System.out.println("filename=" + fileName);
        documentModel.targetCompanyAttachmentName = fileName;
        documentModel.anahataRepDistance = p.getDistanceTo(documentModel.anahataRepLat, documentModel.anahataRepLon);
        System.out.println("distance = " + documentModel.anahataRepDistance);
        documentModel.targetCompany = p.getAccountName();
        documentModel.targetCompanyEmail = p.getEmailAddress();
        documentModel.targetCompanyPhone = p.getPhonesDisplay();
        documentModel.targetCompanyWebsite = p.getCustom().getWebsite();
        if (documentModel.targetCompanyWebsite.length() < 9) {
            documentModel.targetCompanyWebsite = null;
        }
        boolean bl = addressPresent = !StringUtils.isBlank((CharSequence)Nvl.nvl((String)p.getPrimaryAddressStreet()));
        if (addressPresent) {
            documentModel.targetCompanyAddress = Nvl.nvl((String)p.getPrimaryAddressStreet()) + " " + Nvl.nvl((String)p.getPrimaryAddressCity());
        }
        documentModel.targetCompanyAddressFull = p.getAddressDisplay();
        String link = p.getCustom().getDetailslink();
        if (link.contains("?")) {
            String linkFinal = link = link.substring(0, link.indexOf("?"));
            if (!REAL) {
                // empty if block
            }
        }
        documentModel.targetCompanyYPLink = link;
        if (Nvl.nvl((String)p.getCustom().getLogo()).length() > 10) {
            System.out.println("Downloading logo " + p.getCustom().getLogo());
            byte[] logoBarr = IOUtils.toByteArray((URI)new URI(p.getCustom().getLogo()));
            FileUtils.writeByteArrayToFile((File)new File("/home/pablo/Pictures/downloaded_logo.gif"), (byte[])logoBarr);
            documentModel.targetCompanyLogo = new ByteArrayInputStream(logoBarr);
        }
        byte[] emailBodyZip = this.renderDoc(emailBodyTemplate, ConversionFormat.FORMAT_HTML, true, documentModel);
        byte[] emailBodyHtml = this.renderDoc(emailBodyTemplate, ConversionFormat.FORMAT_HTML, false, documentModel);
        byte[] emailBodyPlain = this.renderDoc(emailBodyTemplate, ConversionFormat.FORMAT_TEXT, false, documentModel);
        byte[] emailAttachment = this.renderDoc(attachmentTemplate, ConversionFormat.FORMAT_PDF, false, documentModel);
        log.info("All docs rendered");
        ProspectEmail pe = new ProspectEmail();
        pe.setProspect(p);
        p.getSentEmails().add(pe);
        if (documentModel.isAnahataRepNear()) {
            pe.setSubject(SUBJECT_IT_REFERRAL_NEAR);
        } else {
            pe.setSubject(SUBJECT_IT_REFERRAL_FAR);
        }
        EmailRecipient rec = new EmailRecipient();
        rec.setEmailAddress(ea);
        rec.setEmail(pe);
        rec.setAddressType("to");
        pe.getRecipients().add(rec);
        EmailText et = new EmailText();
        et.setEmail(pe);
        pe.setText(et);
        et.setFromAddr(documentModel.getAnahataRepEmail());
        et.setToAddrs(ea.getEmailAddress());
        et.setDescription(new String(emailBodyPlain));
        et.setDescriptionHtml(new String(emailBodyHtml));
        EmailNote en = new EmailNote();
        en.setEmail(pe);
        pe.getNotes().add(en);
        en.setName(NOTE_NAME);
        en.setFilename(fileName);
        en.setFileMimeType("application/pdf");
        File attachmentTemp = AnahataFileUtils.createTempFile((String)fileName, (byte[])emailAttachment, (boolean)true);
        FileUtils.writeByteArrayToFile((File)attachmentTemp, (byte[])emailAttachment);
        if (REAL) {
            new Thread(() -> {}).start();
        }
        new Thread(() -> {
            try {
                File file = this.unZipIt(emailBodyZip);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
        if (REAL) {
            String dest = "/var/www/html/sugar/upload/" + en.getId();
            System.out.println("SCP to " + dest);
            this.scp.copy(attachmentTemp, dest);
            System.out.println("SCP Completed");
        }
        if (REAL) {
            this.begin();
            System.out.println("Persisting");
            this.persist(pe);
            System.out.println("Flusing ");
            this.flush();
            System.out.println("Flushed");
        }
        Email email = new Email();
        email.setZippedContent(emailBodyZip);
        email.setFrom(documentModel.getAnahataRepEmail());
        email.setSubject(pe.getSubject());
        if (REAL) {
            email.getTo().add(ea.getEmailAddress());
        } else {
            email.getTo().add("ins-npjxxbmv@isnotspam.com");
        }
        email.getCc().add("Pablo Rodriguez Pina <pablo@anahata.net.au>");
        email.getAttachments().add(new ByteArrayAttachment(fileName, emailAttachment));
        System.out.println("Sending email to " + email.getTo());
        int count = SpamKeywords.count(new String(emailBodyPlain));
        System.out.println("Total spam: " + count);
        this.emailService.sendEmail(email);
        System.out.println("Sending email to " + email.getTo() + " OK");
        if (REAL) {
            this.sendSms(p, ea, documentModel);
            System.out.println("Comitting");
            this.commit();
            System.out.println("Commit OK");
        }
    }

    private String normalizeMobileNo(String s) {
        if ((s = Nvl.nvl((String)s).trim().replaceAll("[^0-9]", "")).startsWith("04")) {
            return "61" + s.substring(1);
        }
        return null;
    }

    private void sendSms(Prospect p, EmailAddress pea, DocumentModel dm) throws Exception {
        String mobile;
        String repMobile = this.normalizeMobileNo(dm.getAnahataRepMobile());
        String string = mobile = REAL ? this.normalizeMobileNo(p.getPhoneMobile()) : repMobile;
        if (mobile != null) {
            String msg = "Hi, Sai from Anahata Technologies here. Sent you email to " + pea.getEmailAddress() + ". Let me know if you would you like to meet " + dm.anahataRepTemptativeDate + "?";
            if (msg.length() > 160) {
                System.err.println("msg length - " + msg.length() + " " + msg);
            }
            Message message = new Message(repMobile, mobile, msg);
            HttpTransport httpTransport = new HttpTransport("zwxxwotb", "Uwf75qCL", "https://www.smsglobal.com/http-api.php");
            System.out.println(httpTransport.buildUrl(message));
            Client client = new Client(httpTransport);
            System.out.println("Sending " + message.getMessage() + " to " + message.getDestination() + " from " + message.getOrigin());
            String response = client.sendMessage(message);
            System.out.println("Sending " + message.getMessage() + " to " + message.getDestination() + " from " + message.getOrigin() + " OK");
            System.out.println(response);
        }
    }

    private byte[] renderDoc(File template, ConversionFormat format, boolean zip, DocumentModel documentModel) throws Exception {
        System.out.println("Rendering " + template + "  in " + format + " zip=" + zip + " dm=" + documentModel);
        DataProviderBuilder dpb = new DataProviderBuilder();
        dpb.addJavaObject((Object)documentModel);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RenderRequest rr = new RenderRequest();
        rr.setTemplateFile(template);
        rr.setOutputStream((OutputStream)baos);
        rr.setPopulationErrorsFatal(Boolean.valueOf(false));
        rr.setDataProvider(dpb.getDataProvider());
        rr.setPopulationErrorsFatal(Boolean.valueOf(true));
        ConversionInstruction ci = new ConversionInstruction();
        ci.setConversionFormats(new ConversionFormat[]{format});
        if (zip) {
            ci.setCompressingSingleDocument(true);
        }
        rr.setConversionInstruction(ci);
        DocumentProcessor.renderDoc((RenderRequest)rr);
        byte[] ret = baos.toByteArray();
        if (format == ConversionFormat.FORMAT_HTML && zip) {
            log.debug("Post-processing HTML document");
            String html = ZipUtils.getString((byte[])ret, (String)".html");
            Validate.notNull((Object)html, (String)"Could not extract HTML from generated zip file", (Object[])new Object[0]);
            html = HtmlDocumentPostProcessor.processHtml(html);
            ret = ZipUtils.replaceString((byte[])ret, (String)".html", (String)html);
            log.debug("HTML post processing completed");
        } else if (format == ConversionFormat.FORMAT_HTML) {
            String html = HtmlDocumentPostProcessor.processHtml(new String(ret));
            ret = html.getBytes();
        }
        return ret;
    }

    public File unZipIt(byte[] zip) {
        byte[] buffer = new byte[1024];
        try {
            File folder = AnahataFileUtils.createTempDir((String)UUID.randomUUID().toString(), (boolean)true, (boolean)true);
            if (!folder.exists()) {
                folder.mkdir();
            }
            ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zip));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                int len;
                String fileName = ze.getName();
                File newFile = new File(folder, fileName);
                System.out.println("file unzip : " + newFile.getAbsoluteFile());
                new File(newFile.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            System.out.println("Done");
            return folder;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void testSendEmail() {
    }

    public static void main(String[] args) throws Exception {
        VicDocumentModel dm = new VicDocumentModel();
        dm.targetCompany = "Login IT";
        dm.targetCompanyAddress = "Dandenong, VIC 3175";
        dm.targetCompanyAddressFull = "Dandenong, VIC 3175";
        dm.targetCompanyEmail = "kamal@loginit.com.au";
        dm.targetCompanyPhone = "0450 316 137 ";
        dm.targetCompanyWebsite = "www.loginit.com.au";
        dm.targetContact = "Kamal Babu";
        dm.targetPosition = "Owner";
        File attachmentTemplate = new File(EmailSender.class.getResource("/templates/ITProposal.odt").toURI());
        byte[] barr = ((EmailSender)Cdi.get(EmailSender.class, (Annotation[])new Annotation[0])).renderDoc(attachmentTemplate, ConversionFormat.FORMAT_PDF, false, dm);
        String fileName = dm.targetCompany + "-Anahata-Proposal";
        fileName = fileName.replaceAll("[^A-Za-z0-9]", "_");
        fileName = fileName.replaceAll("[^A-Za-z0-9]", "_");
        fileName = fileName.replaceAll("__", "_");
        fileName = fileName.replaceAll("__", "_");
        fileName = fileName.replaceAll("__", "_");
        fileName = fileName.replaceAll("__", "_");
        fileName = fileName + ".pdf";
        File temp = AnahataFileUtils.createTempFile((String)fileName, (boolean)false);
        FileUtils.writeByteArrayToFile((File)temp, (byte[])barr);
        Desktop.getDesktop().open(temp.getParentFile());
    }

    public static void main2(String[] args) throws Exception {
        System.out.println("public static void main({})" + Arrays.asList(args));
        int rounds = 50;
        for (int i = 0; i < rounds; ++i) {
            ((EmailSender)Cdi.get(EmailSender.class, (Annotation[])new Annotation[0])).migrate();
            System.out.println("----------------");
            System.out.println("--- Round " + i + " Completed");
            System.out.println("----------------");
        }
    }

    static {
        SystemManager.initialise();
        REAL = true;
    }

    public static class VicDocumentModel
    extends DocumentModel {
        public VicDocumentModel() {
            this.anahataWebsiteLink = "www.anahata.melbourne|http://www.anahata.melbourne";
            this.anahataEmailLink = "info@anahata.melbourne|mailto:info@anahata.melbourne";
            this.anahataPhoneLink = "9018 5053|tel:+61390185053";
            this.anahataRep = "Sai Pradeep Dandem";
            this.anahataRepLat = -37.7036296;
            this.anahataRepLon = 144.766112;
            this.anahataRepPosition = "Senior Software Engineer\nVictoria Regional Manager";
            this.anahataRepCertifications = "Oracle Certified Professional, Java SE 8 Programmer\nOracle Certified Expert, EE 6 Java Persistence API Developer";
            this.anahataRepPlainEmail = "sai@anahata.melbourne";
            this.anahataRepPhone = "9018 5053";
            this.anahataRepMobile = "0405 465 529";
            this.anahataRepExt = "02";
            this.comission1stInvoice = "20";
            this.comissionOngoingInvoice = "10";
        }

        @Override
        public String toString() {
            return "EmailSender.VicDocumentModel(super=" + super.toString() + ")";
        }
    }

    public static class WaDocumentModel
    extends DocumentModel {
        public WaDocumentModel() {
            this.anahataRep = "Gaurav Desai";
            this.anahataRepPlainEmail = "gaurav@anahata.net.au";
            this.anahataRepPosition = "Business Development Manager";
            this.anahataRepPhone = "08 6467 0324";
            this.anahataRepMobile = "0430 399 744";
            this.anahataRepExt = "09";
        }

        @Override
        public String toString() {
            return "EmailSender.WaDocumentModel(super=" + super.toString() + ")";
        }
    }

    public static class DocumentModel {
        public String targetCompany;
        public String targetCompanyAddress;
        public String targetCompanyAddressFull;
        public String targetCompanyWebsite;
        public String targetCompanyPhone;
        public String targetCompanyEmail;
        public String targetCompanyYPLink;
        public String targetCompanyAttachmentName;
        public InputStream targetCompanyLogo;
        public String targetContact;
        public String targetPosition = "General Manager";
        public String anahataWebsiteLink = "www.anahata.net.au|http://www.anahata.net.au";
        public String anahataEmailLink = "info@anahata.net.au|mailto:info@anahata.net.au";
        public String anahataPhoneLink = "1300 47 12 23|tel:+61864670324";
        public String anahataRep = "Pablo Rodriguez Pina";
        public double anahataRepLat = -1.0;
        public double anahataRepLon = -1.0;
        public double anahataRepDistance = Double.MAX_VALUE;
        public String anahataRepTemptativeDate = "tomorrow";
        public String anahataRepCertifications = "";
        public String anahataRepPlainEmail = "pablo@anahata.net.au";
        public String anahataRepPosition = "Director, CTO";
        public String anahataRepPhone = "08 6467 0324";
        public String anahataRepMobile = "0410 915 078";
        public String anahataRepExt = "01";
        public String comission1stInvoice = "20";
        public String comissionOngoingInvoice = "10";

        public String getToday() {
            return DateFormat.getDateInstance(2).format(new Date());
        }

        public boolean isTargetCompanyAddressKnown() {
            return this.targetCompanyAddress != null;
        }

        public boolean isAnahataRepNear() {
            return this.getAnahataRepDistance() <= 50.0;
        }

        public boolean isTargetCompanyAddressNotKnown() {
            return !this.isTargetCompanyAddressKnown();
        }

        public String getAnahataRepFirstName() {
            return this.getAnahataRep().split(" ")[0];
        }

        public String getAnahataRepEmail() {
            return this.getAnahataRep() + " <" + this.getAnahataRepPlainEmail() + ">";
        }

        public String getAnahataRepEmailLink() {
            return this.getAnahataRepPlainEmail() + "|mailto:" + this.getAnahataRepPlainEmail();
        }

        public String getAnahataRepPhoneLink() {
            return this.getAnahataRepPhone() + "|tel:" + this.getAnahataRepPhone().replace(" ", "");
        }

        public String getAnahataRepMobileLink() {
            return this.getAnahataRepMobile() + "|tel:" + this.getAnahataRepMobile().replace(" ", "");
        }

        public String getTargetCompany() {
            return this.targetCompany;
        }

        public String getTargetCompanyAddress() {
            return this.targetCompanyAddress;
        }

        public String getTargetCompanyAddressFull() {
            return this.targetCompanyAddressFull;
        }

        public String getTargetCompanyWebsite() {
            return this.targetCompanyWebsite;
        }

        public String getTargetCompanyPhone() {
            return this.targetCompanyPhone;
        }

        public String getTargetCompanyEmail() {
            return this.targetCompanyEmail;
        }

        public String getTargetCompanyYPLink() {
            return this.targetCompanyYPLink;
        }

        public String getTargetCompanyAttachmentName() {
            return this.targetCompanyAttachmentName;
        }

        public InputStream getTargetCompanyLogo() {
            return this.targetCompanyLogo;
        }

        public String getTargetContact() {
            return this.targetContact;
        }

        public String getTargetPosition() {
            return this.targetPosition;
        }

        public String getAnahataWebsiteLink() {
            return this.anahataWebsiteLink;
        }

        public String getAnahataEmailLink() {
            return this.anahataEmailLink;
        }

        public String getAnahataPhoneLink() {
            return this.anahataPhoneLink;
        }

        public String getAnahataRep() {
            return this.anahataRep;
        }

        public double getAnahataRepLat() {
            return this.anahataRepLat;
        }

        public double getAnahataRepLon() {
            return this.anahataRepLon;
        }

        public double getAnahataRepDistance() {
            return this.anahataRepDistance;
        }

        public String getAnahataRepTemptativeDate() {
            return this.anahataRepTemptativeDate;
        }

        public String getAnahataRepCertifications() {
            return this.anahataRepCertifications;
        }

        public String getAnahataRepPlainEmail() {
            return this.anahataRepPlainEmail;
        }

        public String getAnahataRepPosition() {
            return this.anahataRepPosition;
        }

        public String getAnahataRepPhone() {
            return this.anahataRepPhone;
        }

        public String getAnahataRepMobile() {
            return this.anahataRepMobile;
        }

        public String getAnahataRepExt() {
            return this.anahataRepExt;
        }

        public String getComission1stInvoice() {
            return this.comission1stInvoice;
        }

        public String getComissionOngoingInvoice() {
            return this.comissionOngoingInvoice;
        }

        public String toString() {
            return "EmailSender.DocumentModel(targetCompany=" + this.getTargetCompany() + ", targetCompanyAddress=" + this.getTargetCompanyAddress() + ", targetCompanyAddressFull=" + this.getTargetCompanyAddressFull() + ", targetCompanyWebsite=" + this.getTargetCompanyWebsite() + ", targetCompanyPhone=" + this.getTargetCompanyPhone() + ", targetCompanyEmail=" + this.getTargetCompanyEmail() + ", targetCompanyYPLink=" + this.getTargetCompanyYPLink() + ", targetCompanyAttachmentName=" + this.getTargetCompanyAttachmentName() + ", targetCompanyLogo=" + this.getTargetCompanyLogo() + ", targetContact=" + this.getTargetContact() + ", targetPosition=" + this.getTargetPosition() + ", anahataWebsiteLink=" + this.getAnahataWebsiteLink() + ", anahataEmailLink=" + this.getAnahataEmailLink() + ", anahataPhoneLink=" + this.getAnahataPhoneLink() + ", anahataRep=" + this.getAnahataRep() + ", anahataRepLat=" + this.getAnahataRepLat() + ", anahataRepLon=" + this.getAnahataRepLon() + ", anahataRepDistance=" + this.getAnahataRepDistance() + ", anahataRepTemptativeDate=" + this.getAnahataRepTemptativeDate() + ", anahataRepCertifications=" + this.getAnahataRepCertifications() + ", anahataRepPlainEmail=" + this.getAnahataRepPlainEmail() + ", anahataRepPosition=" + this.getAnahataRepPosition() + ", anahataRepPhone=" + this.getAnahataRepPhone() + ", anahataRepMobile=" + this.getAnahataRepMobile() + ", anahataRepExt=" + this.getAnahataRepExt() + ", comission1stInvoice=" + this.getComission1stInvoice() + ", comissionOngoingInvoice=" + this.getComissionOngoingInvoice() + ")";
        }
    }
}

