/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.scp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class Scp {
    final String host;
    final int port;
    final String user;
    final String pass;
    private JSch jsch;
    private Session session;

    public void copy(File source, String target) throws Exception {
        if (this.session == null) {
            System.out.println("Creating SCP session");
            this.connect();
        }
        FileInputStream fis = null;
        try {
            String command = "scp -t " + target;
            Channel channel = this.session.openChannel("exec");
            System.out.println("exec command " + command);
            ((ChannelExec)channel).setCommand(command);
            ((ChannelExec)channel).setErrStream((OutputStream)System.err);
            ((ChannelExec)channel).setOutputStream((OutputStream)System.out);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            System.out.println("channel connecting");
            channel.connect();
            System.out.println("channel connected, checking ack");
            int ack = Scp.checkAck(in);
            if (ack != 0) {
                throw new RuntimeException("checkAck returned " + ack);
            }
            System.out.println("channel connected");
            long filesize = source.length();
            command = "C0644 " + filesize + " " + source.getName();
            command = command + "\n";
            System.out.println("Executing " + command);
            out.write(command.getBytes());
            out.flush();
            ack = Scp.checkAck(in);
            if (ack != 0) {
                throw new RuntimeException("checkAck returned " + ack);
            }
            System.out.println("transfering file");
            fis = new FileInputStream(source);
            byte[] buf = new byte[1024];
            int progress = 0;
            while (true) {
                int len = fis.read(buf, 0, buf.length);
                progress += len;
                if (len <= 0) break;
                out.write(buf, 0, len);
                System.out.println("Tx " + (int)(100.0 * ((double)progress / (double)filesize)) + " %");
            }
            System.out.println("No more bytes to read");
            fis.close();
            fis = null;
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            if (Scp.checkAck(in) != 0) {
                throw new RuntimeException();
            }
            out.close();
            System.out.println("Done");
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public void connect() throws Exception {
        this.jsch = new JSch();
        this.session = this.jsch.getSession(this.user, this.host, this.port);
        this.session.setPassword(this.pass);
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        this.session.setConfig(config);
        System.out.println("SCP Connecting");
        this.session.connect();
        System.out.println("SCP Connected");
    }

    public void disconnect() {
        this.session.disconnect();
    }

    static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                System.out.print(sb.toString());
            }
            if (b == 2) {
                System.out.print(sb.toString());
            }
        }
        return b;
    }

    public static void main(String[] args) throws Exception {
        Scp scp = new Scp("p.anahata.uno", 10008, "admin", "Yog1Bear08");
        scp.connect();
        scp.copy(new File("/home/pablo/Documents/ITProposal.pdf"), "/var/www/html/sugar/upload/ITProposal.pdf");
    }

    @ConstructorProperties(value={"host", "port", "user", "pass"})
    public Scp(String host, int port, String user, String pass) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.pass = pass;
    }
}

