/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.realestatecomau;

import com.anahata.util.lang.builder.DelimitedStringBuilder;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class Scraper {
    public String getProperties(String type, String address, int pages) throws Exception {
        DelimitedStringBuilder ret = new DelimitedStringBuilder("\n");
        for (int i = 1; i <= pages; ++i) {
            String addressEncoded = URLEncoder.encode("Parkerville WA 6081", "UTF-8");
            String url = "https://www.realestate.com.au/" + type + "/in-" + addressEncoded + "/list-" + i;
            Document doc = Jsoup.parse((URL)new URL(url), (int)10000);
            for (Element e : doc.select("div[class=property-card__content-wrapper]")) {
                String price = e.select("span[class=\"property-price\"]").first().text();
                String streetAddress = e.select("span[class=\"property-card__street-address\"").first().text();
                String suburb = e.select("span[class=\"property-card__suburb\"").first().text();
                String propertyType = e.select("span[class=\"property-card__property-type\"").first().text();
                String soldDate = e.select("span[class=\"property-card__sold-date\"").first().text();
                System.out.println("address = " + address);
                DelimitedStringBuilder line = new DelimitedStringBuilder(",");
                line.append(StringEscapeUtils.escapeCsv((String)price));
                line.append(StringEscapeUtils.escapeCsv((String)streetAddress));
                line.append(StringEscapeUtils.escapeCsv((String)suburb));
                line.append(StringEscapeUtils.escapeCsv((String)propertyType));
                line.append(StringEscapeUtils.escapeCsv((String)soldDate));
                ret.append(line.toString());
            }
        }
        return ret.toString();
    }

    public static void main(String[] args) throws Exception {
        System.out.println(new SimpleDateFormat("dd MMM yyyy").parse("28 Sep 2016"));
    }
}

