/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.tech.web;

import com.anahata.util.image.ScaleImage;
import com.anahata.util.mime.MimeUtils;
import com.anahata.yam.model.media.Media;
import com.anahata.yam.service.media.MediaServiceLocal;
import java.io.IOException;
import java.util.Enumeration;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="MediaServlet", urlPatterns={"/media/*"})
public class MediaServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(MediaServlet.class);
    @Inject
    MediaServiceLocal mediaService;

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long id;
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            log.debug("Header: {}", (Object)headerName);
            Enumeration headers = request.getHeaders(headerName);
            while (headers.hasMoreElements()) {
                String headerValue = (String)headers.nextElement();
                log.debug("\t{}", (Object)headerValue);
            }
        }
        try {
            id = new Long(request.getPathInfo().substring(1));
        }
        catch (Exception e) {
            response.setStatus(400);
            log.warn("Bad request, could not locate or parse id and format from request parameters ", (Throwable)e);
            return;
        }
        Media media = this.mediaService.findMedia(id);
        if (media == null) {
            response.setStatus(404);
            log.warn("Could not locate Media for id {}", (Object)id);
            return;
        }
        byte[] content = media.getContent();
        String siteStr = request.getParameter("size");
        if (!StringUtils.isEmpty((CharSequence)siteStr)) {
            Integer size;
            try {
                size = new Integer(siteStr);
            }
            catch (Exception e) {
                response.setStatus(400);
                log.warn("Invalid size " + siteStr, (Throwable)e);
                return;
            }
            long ts = System.currentTimeMillis();
            String format = MimeUtils.getMimeType((byte[])content, (String)"");
            if (format.indexOf("/") > -1) {
                format = format.split("/")[1];
            }
            content = ScaleImage.scale((byte[])media.getContent(), (int)size, (int)size, (String)format);
            ts = System.currentTimeMillis() - ts;
            log.debug("Resied image from {} original size {}b to {}b, took={} ms.", new Object[]{size, media.getContent().length, content.length, ts});
        }
        response.setStatus(200);
        response.setHeader("Content-Length", String.valueOf(content.length));
        response.getOutputStream().write(content);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (IOException | ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public String getServletInfo() {
        return "Media Servlet";
    }
}

