/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.tech.web;

import com.anahata.util.io.AnahataCompressionUtils;
import com.anahata.util.io.CompressionType;
import com.anahata.yam.model.dms.Revision;
import com.anahata.yam.service.dms.DmsServiceLocal;
import com.anahata.yam.service.dms.mirror.MirrorServiceImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.ejb.EJB;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="DmsUloadServlet", urlPatterns={"/dms/upload/*"})
public class DmsUploadServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(DmsUploadServlet.class);
    private static final long PROGRESS_UPLOAD_CHUNK = 102400L;
    @EJB
    private MirrorServiceImpl mirror;
    @EJB
    private DmsServiceLocal dmsLocal;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Long uncompressedSize;
        String revisionId;
        CompressionType compressionType = null;
        String fileName = null;
        try {
            revisionId = request.getParameter("id");
            log.info("parsed revision id = {}", (Object)revisionId);
            Revision r = this.dmsLocal.findRevisionLocal(revisionId);
            uncompressedSize = r.getFileSize();
            fileName = r.getFileName();
            compressionType = AnahataCompressionUtils.readHeader((HttpServletRequest)request);
            if (compressionType == null) {
                compressionType = CompressionType.NONE;
            }
        }
        catch (Throwable e) {
            response.setStatus(400);
            log.warn("Bad request, could not locate or parse id, size or compressinType format from request parameters ", e);
            return;
        }
        log.info("will attempt to start upload for revision id = {} fileName = {} uncompressedSize = {} compressionType = {}", new Object[]{revisionId, fileName, uncompressedSize, compressionType});
        if (this.mirror.startUpload(revisionId)) {
            log.info("Upload started for revision id = {} fileName = {} uncompressedSize = {} compressionType = {}", new Object[]{revisionId, fileName, uncompressedSize, compressionType});
            try {
                int numRead;
                InputStream is = AnahataCompressionUtils.newUncompressingInputStream((CompressionType)compressionType, (InputStream)request.getInputStream());
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                long totalRead = 0L;
                long readSinceLastProgressUpload = 0L;
                byte[] chunk = new byte[262144];
                boolean continueUpload = true;
                while ((numRead = is.read(chunk, 0, chunk.length)) != -1) {
                    buffer.write(chunk, 0, numRead);
                    totalRead += (long)numRead;
                    if ((readSinceLastProgressUpload += (long)numRead) < 102400L) continue;
                    float progress = (float)totalRead / (float)uncompressedSize.longValue();
                    log.info("Calling progressUpload for revision {} progress={} {}", new Object[]{fileName, Float.valueOf(progress), revisionId});
                    continueUpload = this.mirror.progressUpload(revisionId, progress);
                    if (!continueUpload) {
                        log.info("Halting upload for revision {} {}", (Object)fileName, (Object)revisionId);
                        response.setStatus(409);
                        break;
                    }
                    readSinceLastProgressUpload = 0L;
                }
                if (continueUpload) {
                    buffer.flush();
                    byte[] data = buffer.toByteArray();
                    log.info("Calling completedUpload for revision {} {}", (Object)fileName, (Object)revisionId);
                    boolean success = this.mirror.completeUpload(revisionId, data);
                    if (success) {
                        log.info("Upload completed for revision {} {}", (Object)fileName, (Object)revisionId);
                    } else {
                        log.info("Did not complete upload for revision {} {}", (Object)fileName, (Object)revisionId);
                    }
                } else {
                    log.info("Did not attempt to complete upload for revision {} {}", (Object)fileName, (Object)revisionId);
                }
                response.setStatus(200);
            }
            catch (Throwable e) {
                log.error("Exception uploading revision", e);
                this.mirror.cancelUpload(revisionId);
                response.setStatus(500);
            }
        } else {
            log.info("Did not start upload for revision {} {}", (Object)fileName, (Object)revisionId);
            response.setStatus(409);
        }
    }
}

