/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.tech.web;

import com.anahata.yam.model.dms.Revision;
import com.anahata.yam.service.dms.DmsServiceLocal;
import com.anahata.yam.service.dms.storage.RevisionStream;
import com.anahata.yam.service.dms.storage.StorageService;
import com.google.api.client.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ejb.EJB;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="DmsPreviewServlet", urlPatterns={"/dms/preview/*"})
public class DmsPreviewServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(DmsPreviewServlet.class);
    @EJB
    private DmsServiceLocal dms;
    @EJB
    private StorageService storage;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("DmsPreviewServlet doGet");
        log.debug("DmsPreviewServlet doGet storage={}", (Object)this.storage);
        int maxWidth = 200;
        int maxHeight = 200;
        String revisionId = request.getParameter("id");
        log.debug("attempting to create preview for {}", (Object)revisionId);
        if (revisionId == null) {
            response.setStatus(400);
            log.warn("Bad request, could not find revision id from request parameters ");
            return;
        }
        try {
            String maxHeightStr;
            String maxWidthStr = request.getParameter("maxWidth");
            if (maxWidthStr != null) {
                maxWidth = Integer.parseInt(maxWidthStr);
            }
            if ((maxHeightStr = request.getParameter("maxHeight")) != null) {
                maxHeight = Integer.parseInt(maxHeightStr);
            }
        }
        catch (Throwable e) {
            response.setStatus(400);
            log.warn("Bad request, could not locate or parse id or size from request parameters ", e);
            return;
        }
        log.info("client requested preview {} size {}", (Object)revisionId, (Object)maxWidth);
        Revision revision = this.dms.findRevisionLocal(revisionId);
        if (revision == null) {
            response.setStatus(400);
            log.warn("Bad request, could not locate revision " + revisionId);
            return;
        }
        if (!revision.isUploaded()) {
            response.setStatus(204);
            log.warn("Revision not yet uploaded " + revisionId + " current status " + revision.getSynchStatus());
            return;
        }
        try (RevisionStream rs = this.storage.getThumbnailStream(revision, maxWidth, maxHeight);){
            if (rs != null) {
                IOUtils.copy((InputStream)rs.getInputStream(), (OutputStream)response.getOutputStream());
                return;
            }
            log.debug("Could not find thumbnail stream for {}", (Object)revision);
        }
        response.setStatus(204);
    }
}

