/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.tech.web;

import com.anahata.util.config.internal.AnahataUtilConfig;
import com.anahata.util.io.AnahataCompressionUtils;
import com.anahata.util.io.CompressionType;
import com.anahata.util.mime.MimeUtils;
import com.anahata.yam.model.dms.Revision;
import com.anahata.yam.service.dms.DmsServiceLocal;
import com.anahata.yam.service.dms.storage.RevisionStream;
import com.anahata.yam.service.dms.storage.StorageService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ejb.EJB;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tika.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="DmsDownloadServlet", urlPatterns={"/dms/download/*"})
public class DmsDownloadServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(DmsDownloadServlet.class);
    @EJB
    private DmsServiceLocal service;
    @EJB
    private StorageService storage;
    @Inject
    private AnahataUtilConfig anahataUtilConfig;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String revisionId;
        try {
            revisionId = request.getParameter("id");
        }
        catch (Throwable e) {
            response.setStatus(400);
            log.warn("Bad request, could not locate or parse id or size from request parameters ", e);
            return;
        }
        Revision revision = this.service.findRevisionLocal(revisionId);
        if (revision == null) {
            response.setStatus(400);
            log.warn("Bad request, could not locate revision " + revisionId);
            return;
        }
        if (!revision.isUploaded()) {
            response.setStatus(204);
            log.warn("Revision not yet uploaded " + revisionId + " current status " + revision.getSynchStatus());
            return;
        }
        try (RevisionStream rs = this.storage.getRevisionStream(revision);){
            if (rs == null) {
                response.setStatus(204);
                log.warn("Could not produce preview for " + revisionId + " current status " + revision.getSynchStatus());
                return;
            }
            InputStream is = rs.getInputStream();
            Object os = response.getOutputStream();
            if (!MimeUtils.isCompressed((String)revision.getMimeType())) {
                CompressionType compression = this.anahataUtilConfig.getRpcCompression();
                if (compression != CompressionType.NONE) {
                    log.debug("Compressing {} with {} ", (Object)revision, (Object)compression);
                    try {
                        os = AnahataCompressionUtils.newCompressingOutputStream((CompressionType)compression, (OutputStream)os);
                        response.setHeader("AnahataCompression", compression.name());
                    }
                    catch (Exception e) {
                        log.warn("could not create compressor output stream ", (Throwable)e);
                    }
                } else {
                    log.debug("Not Compressing {} as config = {} ", (Object)revision, (Object)compression);
                }
            } else {
                log.debug("Not Compressing {} as mime type {} indicates file is already compressed ", (Object)revision, (Object)revision.getMimeType());
            }
            IOUtils.copy((InputStream)is, (OutputStream)os);
            os.close();
        }
    }
}

