/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.tech.push.jms;

import com.anahata.util.cdi.Cdi;
import com.anahata.util.jms.AnahataJmsUtils;
import com.anahata.util.transport.rpc.Rpc;
import com.anahata.util.transport.rpc.RpcStreamer;
import com.anahata.util.web.remoteinfo.RemoteInfo;
import com.anahata.yam.tech.Yam;
import com.anahata.yam.tech.push.PushHandler;
import com.anahata.yam.tech.push.PushSelector;
import com.anahata.yam.tech.push.PushSelectorProperty;
import com.anahata.yam.tech.push.YamPush;
import com.anahata.yam.tech.pushpull.ApplicationInstanceSelector;
import com.anahata.yam.tech.pushpull.ClassMetadataSelector;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class JmsPushHandler
implements InvocationHandler,
PushHandler {
    private static final Logger log = LoggerFactory.getLogger(JmsPushHandler.class);
    @Inject
    @Yam
    private ConnectionFactory factory;
    @Inject
    @YamPush
    private Topic destination;
    @Inject
    private RpcStreamer streamer;
    private Class clazz;
    private PushSelector selector;

    public void init(Class clazz, PushSelector selector) {
        Validate.isTrue((this.clazz == null ? 1 : 0) != 0, (String)"handler already initialised", (Object[])new Object[0]);
        this.clazz = clazz;
        this.selector = selector;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        log.debug("Preparing JMS message for {}.{} selector={}", new Object[]{this.clazz, method.getName(), ClassMetadataSelector.create((Class)this.clazz, (Method[])new Method[]{method})});
        Rpc rpc = new Rpc(method.getDeclaringClass(), method, args);
        try (Connection con = this.factory.createConnection();
             Session s = con.createSession();){
            BytesMessage message = s.createBytesMessage();
            message.setStringProperty(ClassMetadataSelector.CLASS.name(), this.clazz.getName());
            message.setStringProperty(ClassMetadataSelector.METHOD.name(), method.toString());
            if (this.selector != null) {
                for (PushSelectorProperty<?> prop : this.selector.getProperties()) {
                    this.addProperty((Message)message, prop.getType(), prop.getPropertyName(), prop.getValue());
                }
                if (this.selector.isMethodParameters()) {
                    for (int i = 0; i < method.getParameterCount(); ++i) {
                        this.addProperty((Message)message, method.getParameters()[i].getType(), method.getParameters()[i].getName(), args[i]);
                    }
                }
            }
            RemoteInfo rif = null;
            try {
                rif = (RemoteInfo)Cdi.get(RemoteInfo.class, (Annotation[])new Annotation[0]);
            }
            catch (Exception e) {
                log.warn("No RemoteInfoFilter found in context: ", (Throwable)e);
            }
            message.setStringProperty("AnahataCompression", this.streamer.getCompressionType().name());
            message.setStringProperty("AnahataSerialization", this.streamer.getSerializationType().name());
            if (rif != null && rif.getRemoteInstanceUID() != null) {
                message.setStringProperty(ApplicationInstanceSelector.SOURCE_APPLICATION_INSTANCE.name(), rif.getRemoteInstanceUID());
            }
            byte[] data = this.streamer.stream((Object)rpc);
            log.debug("streamed object: writing {} bytes to message", (Object)data.length);
            message.writeBytes(data);
            log.debug("Sending JMS Message: {} with properties {} to {}", new Object[]{message, AnahataJmsUtils.propertiesToString((Message)message), this.destination});
            try (MessageProducer mp = s.createProducer((Destination)this.destination);){
                mp.setDeliveryMode(1);
                mp.send((Message)message);
            }
        }
        log.debug("JMS message sent for {}.{}", (Object)this.clazz.getSimpleName(), (Object)method.getName());
        return null;
    }

    private void addProperty(Message message, Class type, String name, Object value) throws JMSException {
        if (type.equals(String.class)) {
            message.setStringProperty(name, (String)value);
        } else if (type.equals(Long.class)) {
            message.setLongProperty(name, ((Long)value).longValue());
        } else if (type.equals(Integer.class)) {
            message.setIntProperty(name, ((Integer)value).intValue());
        } else {
            throw new UnsupportedOperationException("Type not supported: " + type);
        }
    }

    @Override
    public PushSelector getSelector() {
        return this.selector;
    }

    @Override
    public void setSelector(PushSelector selector) {
        this.selector = selector;
    }
}

