/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.tech.error;

import com.anahata.util.error.ErrorDetail;
import com.anahata.util.error.ErrorLodgementException;
import com.anahata.util.error.ErrorService;
import com.anahata.util.logging.logback.ErrorEvent;
import com.anahata.yam.tech.ServerConfig;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ServerErrorEventListener {
    private static final Logger log = LoggerFactory.getLogger(ServerErrorEventListener.class);
    @Inject
    private ServerConfig config;
    @Inject
    private ErrorService errorService;

    public void processEvents(@Observes ErrorEvent errorEvent) {
        ErrorDetail error = new ErrorDetail.Builder().about(this.config.getAboutConfig(), "Server").events(errorEvent.getLoggingEvents()).build();
        try {
            this.errorService.lodge(error);
        }
        catch (ErrorLodgementException e) {
            log.warn("Error lodging error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

