/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.tech.docmosis;

import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlDocumentPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(HtmlDocumentPostProcessor.class);

    public static String processHtml(@NonNull String html) {
        if (html == null) {
            throw new NullPointerException("html");
        }
        Document doc = Jsoup.parse((String)html);
        Elements styles = doc.select("html > head > style");
        Validate.isTrue((styles.size() == 1 ? 1 : 0) != 0, (String)"More than one head style encountered, size=%d", (long)styles.size());
        Element style = styles.first();
        style.text("P { margin-top: 0; margin-bottom: 0; }");
        return doc.outerHtml();
    }

    private HtmlDocumentPostProcessor() {
    }
}

