/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.tech;

import com.anahata.util.config.AboutConfig;
import com.anahata.util.config.OutgoingEmailConfig;
import com.anahata.util.config.internal.ApplicationPropertiesFactory;
import com.anahata.util.env.ApplicationEnvironment;
import com.anahata.util.props.StructuredProperties;
import com.anahata.yam.model.dms.databasebackup.DatabaseBackupConfig;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@javax.faces.bean.ApplicationScoped
@ApplicationScoped
@Named(value="serverConfig")
public class ServerConfig
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ServerConfig.class);
    @Inject
    private ApplicationPropertiesFactory appPropsFactory;
    private AboutConfig aboutConfig;
    private OutgoingEmailConfig outgoingEmailConfig;
    private DatabaseBackupConfig databaseBackupConfig;
    private boolean errorLodgementEnabled;
    private long heartBeatInterval;
    private boolean batchJobsEnabled;
    private boolean trackingEnabled;
    private boolean userSessionCleanupBatchEnabled;
    private boolean dmsEnabled;
    private List<Annotation> storageProviders;
    private boolean dmsEventPublishingEnabled;
    private boolean dmsUploadsProgressEnabled;
    private boolean dmsRevisionDataCleanupEnabled;
    private boolean databaseBackupEnabled;
    private Integer requestCleanupDays;

    @PostConstruct
    void postConstruct() {
        Properties appProperties = this.appPropsFactory.getAppProperties();
        this.aboutConfig = new AboutConfig(appProperties, new String[]{"yam"});
        this.outgoingEmailConfig = new OutgoingEmailConfig(appProperties, new String[]{"yam", "outgoing.email"});
        StructuredProperties props = new StructuredProperties(appProperties, new String[]{"yam"});
        this.errorLodgementEnabled = props.getBoolean("error.lodgement.enabled", true);
        this.heartBeatInterval = props.getLong("heartbeat.interval", Long.valueOf(3000L));
        this.batchJobsEnabled = props.getBoolean("batch.jobs.enabled", true);
        this.trackingEnabled = props.getBoolean("tracking.enabled", false);
        if (this.trackingEnabled) {
            this.userSessionCleanupBatchEnabled = props.getBoolean("batch.usersessioncleanup.enabled", this.trackingEnabled);
            this.requestCleanupDays = props.getInteger("request.cleanup.days", Integer.valueOf(14));
        }
        this.dmsEnabled = props.getBoolean("dms.enabled", true);
        if (this.dmsEnabled) {
            this.dmsEventPublishingEnabled = props.getBoolean("dms.event.publishing.enabled", true);
            this.dmsUploadsProgressEnabled = props.getBoolean("dms.uploads.progress.enabled", true);
            this.dmsRevisionDataCleanupEnabled = props.getBoolean("dms.revision.data.cleanup.enabled", true);
        }
        this.databaseBackupEnabled = props.getBoolean("backup.enabled", false);
        this.databaseBackupConfig = new DatabaseBackupConfig(appProperties, new String[]{"yam", "backup"});
    }

    public String getAppName() {
        return this.aboutConfig.getAppName();
    }

    public String getAppNameWithEnvironmentIfNotProd() {
        return this.aboutConfig.getAppNameWithEnvironmentIfNotProd();
    }

    public String getAppOwner() {
        return this.aboutConfig.getAppOwner();
    }

    public String getAppVersion() {
        return this.aboutConfig.getAppVersion();
    }

    public String getBuildNumber() {
        return this.aboutConfig.getBuildNumber();
    }

    public Date getBuildTimestamp() {
        return this.aboutConfig.getBuildTimestamp();
    }

    public String getFormattedBuildTimestamp() {
        return this.aboutConfig.getFormattedBuildTimestamp();
    }

    public String getBuildUID() {
        return this.aboutConfig.getBuildUID();
    }

    public String getAppTitle() {
        return this.aboutConfig.getAppTitle();
    }

    public ApplicationEnvironment getEnvironment() {
        return this.aboutConfig.getEnvironment();
    }

    public String getBaseUrl() {
        return this.aboutConfig.getBaseUrl();
    }

    public AboutConfig getAboutConfig() {
        return this.aboutConfig;
    }

    public OutgoingEmailConfig getOutgoingEmailConfig() {
        return this.outgoingEmailConfig;
    }

    public DatabaseBackupConfig getDatabaseBackupConfig() {
        return this.databaseBackupConfig;
    }

    public boolean isErrorLodgementEnabled() {
        return this.errorLodgementEnabled;
    }

    public long getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    public boolean isBatchJobsEnabled() {
        return this.batchJobsEnabled;
    }

    public boolean isTrackingEnabled() {
        return this.trackingEnabled;
    }

    public boolean isUserSessionCleanupBatchEnabled() {
        return this.userSessionCleanupBatchEnabled;
    }

    public boolean isDmsEnabled() {
        return this.dmsEnabled;
    }

    public List<Annotation> getStorageProviders() {
        return this.storageProviders;
    }

    public boolean isDmsEventPublishingEnabled() {
        return this.dmsEventPublishingEnabled;
    }

    public boolean isDmsUploadsProgressEnabled() {
        return this.dmsUploadsProgressEnabled;
    }

    public boolean isDmsRevisionDataCleanupEnabled() {
        return this.dmsRevisionDataCleanupEnabled;
    }

    public boolean isDatabaseBackupEnabled() {
        return this.databaseBackupEnabled;
    }

    public Integer getRequestCleanupDays() {
        return this.requestCleanupDays;
    }
}

