/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.tech;

import com.anahata.yam.service.template.exception.TemplateInitialisationException;
import com.anahata.yam.tech.ServerConfig;
import com.docmosis.SystemManager;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Startup
public class LifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(LifecycleListener.class);
    @Inject
    public ServerConfig config;

    @PostConstruct
    private void startup() {
        Locale.setDefault(new Locale("en", "AU"));
        log.info("ApplicationLifecycleListener startup(). Setting JNLP Properties");
        this.initJnlpProperties();
        log.info("ApplicationLifecycleListener startup(). JNLP Properties set");
        try {
            this.initDocmosis();
        }
        catch (Exception e) {
            throw new RuntimeException("Template initialisation failed, deployment halted", e);
        }
    }

    private void initJnlpProperties() {
        System.setProperty("yam.jnlp.title.short", this.config.getAppNameWithEnvironmentIfNotProd());
        log.info("yam.jnlp.title.short=" + System.getProperty("yam.jnlp.title.short"));
        System.setProperty("yam.jnlp.title", this.config.getAppTitle());
        System.setProperty("yam.jnlp.menu", this.config.getAppName());
        System.setProperty("yam.build.uid", this.config.getBuildUID());
    }

    private void initDocmosis() throws TemplateInitialisationException {
        if (!SystemManager.isInitialized()) {
            SystemManager.initialise();
        }
    }

    @PreDestroy
    private void shutdown() {
        log.info("ApplicationLifecycleListener shutdown");
        this.shutdownDocmosis();
    }

    private void shutdownDocmosis() {
        log.info("Shutting down docmosis");
        if (SystemManager.isInitialized()) {
            log.trace("Shutting down SystemManager");
            SystemManager.release();
        } else {
            log.warn("System Manager was not initialised");
        }
    }
}

