/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.user;

import com.anahata.util.jpa.JPAUtils;
import com.anahata.util.jpa.eclipselink.TypedCopyGroup;
import com.anahata.util.logging.Logged;
import com.anahata.yam.model.Base_;
import com.anahata.yam.model.document.DocumentFormat;
import com.anahata.yam.model.template.model.DocumentModel;
import com.anahata.yam.model.template.model.LogonDetailsEmail;
import com.anahata.yam.model.user.Group;
import com.anahata.yam.model.user.User;
import com.anahata.yam.model.user.UserLogon;
import com.anahata.yam.model.user.User_;
import com.anahata.yam.service.error.ServiceErrorCode;
import com.anahata.yam.service.error.ServiceException;
import com.anahata.yam.service.media.AbstractDomainService;
import com.anahata.yam.service.tracking.NotTracked;
import com.anahata.yam.service.tracking.Tracked;
import com.anahata.yam.service.tracking.TrackingServiceImpl;
import com.anahata.yam.service.user.UserServiceLocal;
import com.anahata.yam.tech.ServerConfig;
import java.util.List;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.commons.lang3.Validate;
import org.eclipse.persistence.sessions.CopyGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tracked
@Logged
public abstract class UserServiceImpl<T extends User>
extends AbstractDomainService<T, Long>
implements UserServiceLocal<T> {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    @Inject
    private TrackingServiceImpl tracker;
    @Inject
    private ServerConfig config;

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public List<T> findAllUsers() {
        return this.copyFull(JPAUtils.selectAll((EntityManager)this.em, this.getEntityType()).getResultList());
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public List<Group> findAllGroups() {
        List l = JPAUtils.selectAll((EntityManager)this.em, Group.class).getResultList();
        TypedCopyGroup ucg = this.getCopyGroupProducer().newDefaultCopyGroup(Group.class);
        return JPAUtils.copy((EntityManager)this.em, (CopyGroup)ucg, (List)l);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public T save(T user, boolean emailPassword) throws ServiceException {
        if (this.hasMatching(user, User_.userName, user.getUserName())) {
            throw new ServiceException(ServiceErrorCode.USER_DUPLICATE_NAME, new Object[]{user.getUserName()});
        }
        user = (User)this.em.merge(user);
        this.em.flush();
        if (emailPassword) {
            this.emailPassword((User)user);
        }
        return (T)((User)this.copyFull(user));
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void resetPassword(Long userId, String password, boolean changePassword, boolean emailPassword) {
        User u = (User)this.em.find(User.class, (Object)userId);
        u.setPassword(password);
        u.setChangePassword(changePassword);
        if (emailPassword) {
            this.emailPassword(u);
        }
    }

    @Override
    @NotTracked(trackOnline=false)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public T getLoggedInUser() {
        T user = this.getUserIfLoggedIn();
        return user;
    }

    @Override
    @NotTracked(trackOnline=false)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public T getUserIfLoggedIn() {
        String userName = this.ctx.getCallerPrincipal().getName();
        List l = JPAUtils.findByField((EntityManager)this.em, this.getEntityType(), (SingularAttribute)User_.userName, (Object[])new Object[]{userName}).setMaxResults(1).getResultList();
        return (T)(l.isEmpty() ? null : (User)l.get(0));
    }

    @NotTracked(trackOnline=false)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void logout() {
        this.tracker.trackRequest(this.getClass().getSimpleName(), "logout", this.remoteInfo.getRemoteAddress(), this.remoteInfo.getRemoteHost());
        this.getLoggedInUser().setOnline(false);
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public UserLogon<T> login() {
        T raw = this.getLoggedInUser();
        User copy = (User)this.copyFull(raw);
        List<Group> groups = this.findAllGroups();
        return new UserLogon(copy, groups);
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public List<Long> getOnlineUserIds() {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        Root from = cq.from(User.class);
        cq.where((Expression)cb.equal((Expression)from.get(User_.online), (Object)true));
        cq.select((Selection)from.get(Base_.id));
        return this.em.createQuery(cq).getResultList();
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public T changePassword(char[] newPassword) {
        T u = this.getLoggedInUser();
        log.debug("User {} changing password to {}", (Object)u.getUserName(), (Object)newPassword);
        u.setPassword(new String(newPassword));
        u.setChangePassword(false);
        this.em.flush();
        return (T)((User)this.copyFull(u));
    }

    private void emailPassword(User user) {
        try {
            Validate.isTrue((user.getFullName() != null ? 1 : 0) != 0, (String)"User %s does not have an associated contact", (Object[])new Object[]{user.getUserName()});
            Validate.isTrue((user.getEmail() != null ? 1 : 0) != 0, (String)"User %s does not have an associated email address ", (Object[])new Object[]{user.getFullName()});
            log.debug("Sending Login Details email to user{} homePage: {}", (Object)user, (Object)this.config.getBaseUrl());
            this.emailService.sendEmail("Login Details", (DocumentModel)new LogonDetailsEmail(user, this.config.getBaseUrl()), user.getEmail(), new DocumentFormat[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

