/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.tracking;

import com.anahata.util.jpa.JPAUtils;
import com.anahata.yam.model.user.User;
import com.anahata.yam.model.user.UserRequest;
import com.anahata.yam.model.user.UserRequest_;
import com.anahata.yam.model.user.User_;
import com.anahata.yam.service.user.UserServiceLocal;
import com.anahata.yam.tech.ServerConfig;
import com.anahata.yam.tech.Yam;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.ejb.Asynchronous;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.SingularAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LocalBean
@Stateless
public class TrackingServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(TrackingServiceImpl.class);
    @Inject
    @Yam
    private EntityManager em;
    @Resource
    private SessionContext ctx;
    @Inject
    private ServerConfig config;
    @EJB
    private UserServiceLocal userService;

    @Asynchronous
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void trackRequest(String service, String method, String remoteAddress, String remoteHost) {
        if (!this.config.isTrackingEnabled()) {
            return;
        }
        User user = this.getUserTrackOnline();
        if (user != null) {
            UserRequest ur = new UserRequest();
            ur.setService(service);
            ur.setMethod(method);
            ur.setDate(user.getLastRequestDate());
            ur.setRemoteAddress(remoteAddress);
            ur.setRemoteHost(remoteHost);
            ur.setUser(user);
            log.trace("Persisting User request {} ", (Object)ur);
            this.em.persist((Object)ur);
        } else {
            log.warn("User not logged in for request service:{} method:{} remoteAddr:{} remoteHost:{}", new Object[]{service, method, remoteAddress, remoteHost});
        }
    }

    @Asynchronous
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void trackOnline() {
        if (!this.config.isTrackingEnabled()) {
            return;
        }
        this.getUserTrackOnline();
    }

    private User getUserTrackOnline() {
        User u = this.getUserIfLoggedIn();
        if (u != null) {
            u.setOnline(true);
            u.setLastRequestDate(new Date());
        }
        this.em.flush();
        return u;
    }

    private User getUserIfLoggedIn() {
        String userName = this.ctx.getCallerPrincipal().getName();
        List l = JPAUtils.findByField((EntityManager)this.em, User.class, (SingularAttribute)User_.userName, (Object[])new Object[]{userName}).setMaxResults(1).getResultList();
        return l.isEmpty() ? null : (User)l.get(0);
    }

    public void cleanupRequestsOlderThan(Date before) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaDelete delete = cb.createCriteriaDelete(UserRequest.class);
        Root root = delete.from(UserRequest.class);
        delete.where((Expression)cb.lessThan((Expression)root.get(UserRequest_.date), (Comparable)before));
        int deleted = this.em.createQuery(delete).executeUpdate();
        log.debug("cleaned up {} entries", (Object)deleted);
    }
}

