/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.tracking;

import com.anahata.util.web.remoteinfo.RemoteInfo;
import com.anahata.yam.service.tracking.NotTracked;
import com.anahata.yam.service.tracking.Tracked;
import com.anahata.yam.service.tracking.TrackingServiceImpl;
import com.anahata.yam.tech.ServerConfig;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
@Tracked
public class TrackedInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TrackedInterceptor.class);
    @Inject
    private TrackingServiceImpl tracker;
    @Inject
    private RemoteInfo remoteInfo;
    @Inject
    private ServerConfig config;

    @AroundInvoke
    private Object track(InvocationContext invocationContext) throws Exception {
        if (!this.config.isTrackingEnabled()) {
            return invocationContext.proceed();
        }
        String beanName = invocationContext.getTarget().getClass().getSimpleName();
        String methodName = invocationContext.getMethod().getName();
        NotTracked notTracked = invocationContext.getMethod().getAnnotation(NotTracked.class);
        boolean track = notTracked == null;
        boolean trackOnline = notTracked != null && notTracked.trackOnline();
        log.trace("TrackedInterceptor id={} bean {} method {} remoteInfo {} @NotTracked {} trackOnline {}", new Object[]{System.identityHashCode(this), beanName, methodName, this.remoteInfo, notTracked, trackOnline});
        if (track) {
            this.tracker.trackRequest(beanName, methodName, this.remoteInfo.getRemoteAddress(), this.remoteInfo.getRemoteHost());
        } else if (trackOnline) {
            this.tracker.trackOnline();
        }
        return invocationContext.proceed();
    }
}

