/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.template;

import com.anahata.util.jpa.JPAUtils;
import com.anahata.yam.model.dms.TemplateDocument;
import com.anahata.yam.model.dms.TemplateDocument_;
import com.anahata.yam.model.template.Template;
import com.anahata.yam.model.template.TemplateDTO;
import com.anahata.yam.service.error.ServiceException;
import com.anahata.yam.service.template.TemplateService;
import com.anahata.yam.service.template.TemplateServiceLocal;
import com.anahata.yam.tech.Yam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
@Deprecated
public class TemplateServiceImpl
implements TemplateServiceLocal,
TemplateService {
    private static final Logger log = LoggerFactory.getLogger(TemplateServiceImpl.class);
    @Inject
    @Yam
    private EntityManager em;

    public byte[] getTemplateContent(String id) throws ServiceException {
        Validate.notNull((Object)id, (String)"id is required", (Object[])new Object[0]);
        return this.findTemplate(id).getContent();
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public TemplateDTO updateTemplate(String id, byte[] content) throws ServiceException {
        try {
            Template t = this.findTemplate(id);
            t.setContent(content);
            this.em.flush();
            return TemplateServiceImpl.makeDTO(t);
        }
        catch (Exception e) {
            log.error("Exception updating template content", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public List<TemplateDTO> findAllTemplates() throws ServiceException {
        List list = JPAUtils.selectAll((EntityManager)this.em, Template.class).getResultList();
        ArrayList<TemplateDTO> ret = new ArrayList<TemplateDTO>(list.size());
        for (Template template : list) {
            if (!template.isActive()) continue;
            ret.add(TemplateServiceImpl.makeDTO(template));
        }
        return ret;
    }

    @Override
    public Template findTemplate(String id) {
        Validate.notNull((Object)id, (String)"id is required", (Object[])new Object[0]);
        Template ret = (Template)this.em.find(Template.class, (Object)id);
        Validate.notNull((Object)ret, (String)"template not found for id %s", (Object[])new Object[]{id});
        return ret;
    }

    @Override
    public TemplateDocument findTemplateDocument(String id) {
        Validate.notNull((Object)id, (String)"id is required", (Object[])new Object[0]);
        List templateDocuments = JPAUtils.findByField((EntityManager)this.em, TemplateDocument.class, (SingularAttribute)TemplateDocument_.templateId, (Object[])new Object[]{id}).getResultList();
        log.debug("templateDocument= {}", (Object)templateDocuments);
        return CollectionUtils.isEmpty((Collection)templateDocuments) ? null : (TemplateDocument)templateDocuments.get(0);
    }

    private static TemplateDTO makeDTO(Template template) {
        TemplateDTO dto = new TemplateDTO();
        dto.setId(template.getId());
        dto.setName(template.getName());
        dto.setLastModified(template.getLastModified());
        dto.setThumbnail(template.getThumbnail());
        dto.setType(template.getType());
        dto.setSize((long)template.getContent().length);
        return dto;
    }
}

