/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.media;

import com.anahata.util.cdi.Cdi;
import com.anahata.util.jpa.JPAUtils;
import com.anahata.util.logging.Logged;
import com.anahata.util.web.remoteinfo.RemoteInfo;
import com.anahata.yam.domain.copy.CopyGroupProducer;
import com.anahata.yam.model.user.User;
import com.anahata.yam.service.DomainService;
import com.anahata.yam.service.dms.DmsServiceLocal;
import com.anahata.yam.service.document.DocumentGenerationService;
import com.anahata.yam.service.email.EmailService;
import com.anahata.yam.service.email.YamEmail;
import com.anahata.yam.service.tracking.Tracked;
import com.anahata.yam.service.user.UserServiceLocal;
import com.anahata.yam.tech.Yam;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.SessionContext;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.commons.lang3.Validate;
import org.eclipse.persistence.sessions.CopyGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Logged
@Tracked
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public abstract class AbstractDomainService<T, I>
implements DomainService<T, I> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDomainService.class);
    @Inject
    @Yam
    protected EntityManager em;
    @Inject
    protected RemoteInfo remoteInfo;
    @Resource
    protected SessionContext ctx;
    @Inject
    protected DocumentGenerationService documentGeneration;
    @EJB
    protected DmsServiceLocal dmsService;
    @Inject
    protected EmailService emailService;
    @EJB
    protected UserServiceLocal userService;
    @Inject
    private CopyGroupProducer copyGroupProducer;

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public T find(I id) {
        Object entity = this.em.find(this.getEntityType(), id);
        Validate.notNull((Object)entity, (String)("No entity of type " + this.getEntityType().getSimpleName() + " could be found for id " + id), (Object[])new Object[0]);
        entity = this.em.find(entity.getClass(), id);
        return (T)this.copy(entity);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public T save(T entity) {
        entity = this.em.merge(entity);
        return this.copy(entity);
    }

    protected <U> U copy(U entity) {
        if (entity == null) {
            return null;
        }
        return this.copy(entity, this.newDefaultCopyGroup(entity.getClass()));
    }

    protected <U> List<U> copy(List<U> list) {
        if (list.isEmpty()) {
            return list;
        }
        Class<?> commonSuper = null;
        for (U o : list) {
            Class<?> c = o.getClass();
            if (commonSuper == null) {
                commonSuper = c;
                continue;
            }
            if (c == commonSuper || !c.isAssignableFrom(commonSuper)) continue;
            commonSuper = c;
        }
        return this.copy((U)list, this.newDefaultCopyGroup(commonSuper));
    }

    protected <U> List<U> copy(List<U> entities, CopyGroup cg) {
        if (entities.isEmpty()) {
            return entities;
        }
        return JPAUtils.copy((EntityManager)this.em, (CopyGroup)cg, entities);
    }

    protected <U> U copy(U entity, CopyGroup copyGroup) {
        if (entity == null) {
            return null;
        }
        Object copy = JPAUtils.copy((EntityManager)this.em, (CopyGroup)copyGroup, entity);
        return (U)copy;
    }

    protected CopyGroup newDefaultCopyGroup() {
        return this.copyGroupProducer.newDefaultCopyGroup(this.getEntityType());
    }

    protected CopyGroup newDefaultCopyGroup(Class c) {
        return this.copyGroupProducer.newDefaultCopyGroup(c);
    }

    protected <A> boolean hasMatching(T entity, SingularAttribute<T, A> matchField, A matchValue) {
        TypedQuery query = JPAUtils.findByField((EntityManager)this.em, this.getEntityType(), matchField, (Object[])new Object[]{matchValue});
        List records = query.getResultList();
        if (records.isEmpty()) {
            return false;
        }
        return records.size() != 1 || !records.get(0).equals(entity);
    }

    protected YamEmail newEmail() {
        return (YamEmail)((Object)Cdi.get(YamEmail.class, (Annotation[])new Annotation[0]));
    }

    public <U extends User> U getLoggedInUser() {
        return this.userService.getLoggedInUser();
    }

    protected abstract Class<T> getEntityType();

    @Deprecated
    protected T copyFull(T entity) {
        return this.copy(entity, this.getFullCopyGroup());
    }

    @Deprecated
    protected CopyGroup getFullCopyGroup() {
        return this.copyGroupProducer.newDefaultCopyGroup(this.getEntityType());
    }

    @Deprecated
    protected List<T> copyFull(List<T> entities) {
        return this.copy((Object)entities, this.getFullCopyGroup());
    }

    protected CopyGroupProducer getCopyGroupProducer() {
        return this.copyGroupProducer;
    }
}

