/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.email;

import com.anahata.util.email.ByteArrayAttachment;
import com.anahata.util.email.Email;
import com.anahata.util.env.ApplicationEnvironment;
import com.anahata.util.lang.Nvl;
import com.anahata.yam.model.delivery.DocumentDelivery;
import com.anahata.yam.model.delivery.DocumentDeliveryAttachment;
import com.anahata.yam.model.dms.Document;
import com.anahata.yam.model.dms.DocumentEmailEvent;
import com.anahata.yam.model.dms.Node;
import com.anahata.yam.model.document.DocumentFormat;
import com.anahata.yam.model.template.model.DocumentDecorator;
import com.anahata.yam.model.template.model.DocumentModel;
import com.anahata.yam.model.template.model.StandardDocument;
import com.anahata.yam.model.template.model.StandardEmail;
import com.anahata.yam.model.user.User;
import com.anahata.yam.service.dms.DmsServiceLocal;
import com.anahata.yam.service.dms.event.callback.DocumentEmailEventCallBack;
import com.anahata.yam.service.dms.storage.StorageService;
import com.anahata.yam.service.document.DocumentGenerationService;
import com.anahata.yam.service.email.SendEmailService;
import com.anahata.yam.service.user.UserServiceLocal;
import com.anahata.yam.tech.ServerConfig;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.ejb.EJB;
import javax.inject.Inject;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YamEmail
extends Email {
    private static final Logger log = LoggerFactory.getLogger(YamEmail.class);
    @Inject
    private ServerConfig config;
    @Inject
    private DocumentGenerationService documentService;
    @Inject
    private StorageService storage;
    @EJB
    private DmsServiceLocal dmsService;
    @EJB
    private UserServiceLocal userService;
    @EJB
    private SendEmailService sender;
    private User user;

    public YamEmail fromLoggedInUser() {
        User loggedInUser = this.getLoggedInUser();
        if (loggedInUser == null) {
            throw new IllegalStateException("Can not send email from logged in user as no user is logged in. If this method is being invoked from a batch job or from a non-protected web page,  you must specify either a from user or a from address manually");
        }
        return this.from(loggedInUser);
    }

    public YamEmail from(@NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        return this.from(user.getFullEmailAddress());
    }

    public YamEmail from(@NonNull String from) {
        if (from == null) {
            throw new NullPointerException("from");
        }
        this.setFrom(from);
        return this;
    }

    public YamEmail to(String ... recipients) {
        if (recipients == null) {
            throw new NullPointerException("recipients");
        }
        this.getTo().addAll(Arrays.asList(recipients));
        return this;
    }

    public YamEmail cc(String ... recipients) {
        if (recipients == null) {
            throw new NullPointerException("recipients");
        }
        this.getCc().addAll(Arrays.asList(recipients));
        return this;
    }

    public YamEmail bcc(String ... recipients) {
        if (recipients == null) {
            throw new NullPointerException("recipients");
        }
        this.getBcc().addAll(Arrays.asList(recipients));
        return this;
    }

    public YamEmail subject(@NonNull String subject) {
        if (subject == null) {
            throw new NullPointerException("subject");
        }
        this.setSubject(subject);
        return this;
    }

    public YamEmail body(@NonNull DocumentModel documentModel) throws Exception {
        if (documentModel == null) {
            throw new NullPointerException("documentModel");
        }
        byte[] body = this.documentService.renderHtml(documentModel);
        super.setZippedContent(body);
        return this;
    }

    public YamEmail standardEmailBody(@NonNull DocumentModel content) throws Exception {
        if (content == null) {
            throw new NullPointerException("content");
        }
        this.body((DocumentModel)new StandardEmail(this.getSubject(), this.getLoggedInUser(), content));
        return this;
    }

    public YamEmail documentDelivery(DocumentDelivery dd) throws Exception {
        this.from(dd.getUser());
        this.to(dd.getEmail());
        if (!StringUtils.isBlank((CharSequence)dd.getEmailCc())) {
            this.cc(dd.getEmailCcAddresses());
        }
        for (DocumentDeliveryAttachment dda : dd.getEmailAttachments()) {
            ByteArrayAttachment baa = new ByteArrayAttachment(dda.getFileName(), dda.getContent());
            this.attachment(baa);
        }
        for (Long l : dd.getDmsEmailAttachments()) {
            this.attachment(l);
        }
        return this;
    }

    public YamEmail attachment(@NonNull String baseFileName, @NonNull DocumentDecorator content, @NonNull DocumentFormat format) throws Exception {
        if (baseFileName == null) {
            throw new NullPointerException("baseFileName");
        }
        if (content == null) {
            throw new NullPointerException("content");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        byte[] body = this.documentService.render((DocumentModel)content, format);
        this.getAttachments().add(new ByteArrayAttachment(baseFileName + "." + format.getExtension(), body));
        return this;
    }

    public YamEmail standardDocumentAttachment(@NonNull String title, @NonNull DocumentModel content, @NonNull DocumentFormat format) throws Exception {
        if (title == null) {
            throw new NullPointerException("title");
        }
        if (content == null) {
            throw new NullPointerException("content");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        this.attachment(title, (DocumentDecorator)new StandardDocument(title, content), format);
        return this;
    }

    public YamEmail attachment(@NonNull List<Document> documents) throws Exception {
        if (documents == null) {
            throw new NullPointerException("documents");
        }
        return this.attachment(documents.toArray(new Document[documents.size()]));
    }

    public YamEmail attachment(Document ... documents) throws Exception {
        if (documents == null) {
            throw new NullPointerException("documents");
        }
        return this.attachment((Function<Document, String>)null, documents);
    }

    public YamEmail attachment(Function<Document, String> titleConverter, Document ... documents) throws Exception {
        if (documents == null) {
            throw new NullPointerException("documents");
        }
        Validate.noNullElements((Object[])documents, (String)"documents contains a null element", (Object[])new Object[0]);
        for (Document document : documents) {
            byte[] content = this.storage.getRevisionBytes(document.getHeadRevision());
            String title = titleConverter != null ? titleConverter.apply(document) : document.getTitle();
            this.getAttachments().add(new ByteArrayAttachment(title, content));
        }
        return this;
    }

    public YamEmail attachment(long ... documentIds) throws Exception {
        if (documentIds == null) {
            throw new NullPointerException("documentIds");
        }
        this.attachment(null, documentIds);
        return this;
    }

    public YamEmail attachment(DocumentEmailEventCallBack<Document> callBack, long ... documentIds) throws Exception {
        if (documentIds == null) {
            throw new NullPointerException("documentIds");
        }
        return this.attachment(callBack, null, documentIds);
    }

    public YamEmail attachment(DocumentEmailEventCallBack<Document> callBack, Function<Document, String> titleConverter, long ... documentIds) throws Exception {
        if (documentIds == null) {
            throw new NullPointerException("documentIds");
        }
        for (long documentId : documentIds) {
            Node node = this.dmsService.findNodeLocal(documentId);
            Validate.isTrue((boolean)(node instanceof Document), (String)"Node id=%s is not a document: %s", (Object[])new Object[]{documentId, node});
            this.attachment(titleConverter, (Document)node);
            if (callBack == null) continue;
            DocumentEmailEvent<Document> event = callBack.call((Document)node);
            this.dmsService.addNodeEvent(event);
        }
        return this;
    }

    public YamEmail attachment(ByteArrayAttachment ... attachments) throws Exception {
        if (attachments == null) {
            throw new NullPointerException("attachments");
        }
        this.getAttachments().addAll(Arrays.asList(attachments));
        return this;
    }

    public void send() throws Exception {
        if (this.getFrom() == null) {
            this.fromLoggedInUser();
        }
        this.sender.send(this);
    }

    public Future<Void> sendAsync() throws Exception {
        if (this.getFrom() == null) {
            this.fromLoggedInUser();
        }
        return this.sender.sendAsync(this);
    }

    public String getSubject() {
        String subject = Nvl.nvl((String)super.getSubject());
        if (this.config.getAboutConfig().getEnvironment() != ApplicationEnvironment.PROD) {
            subject = subject + " ( " + this.config.getAppName() + " " + this.config.getAboutConfig().getEnvironment() + " environment) ";
        }
        return subject;
    }

    private User getLoggedInUser() {
        if (this.user == null) {
            this.user = this.userService.getUserIfLoggedIn();
        }
        return this.user;
    }
}

