/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.email;

import com.anahata.util.email.Email;
import com.anahata.util.email.OutgoingEmailService;
import com.anahata.yam.service.error.ServiceException;
import com.anahata.yam.tech.ServerConfig;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;
import javax.ejb.AsyncResult;
import javax.ejb.Asynchronous;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@LocalBean
public class SendEmailService {
    private static final Logger log = LoggerFactory.getLogger(SendEmailService.class);
    @Inject
    private ServerConfig config;
    private OutgoingEmailService outgoingEmailService;

    @PostConstruct
    private void init() {
        this.outgoingEmailService = new OutgoingEmailService(this.config.getOutgoingEmailConfig());
    }

    @Asynchronous
    public Future<Void> sendAsync(Email email) {
        this.send(email);
        return new AsyncResult(null);
    }

    public void send(Email email) throws ServiceException {
        long ts = System.currentTimeMillis();
        try {
            this.outgoingEmailService.sendEmail(email);
            ts = System.currentTimeMillis() - ts;
            log.debug("Sending email {} took {}", (Object)email, (Object)ts);
        }
        catch (Throwable e) {
            log.error("Exception sending email", e);
            throw new ServiceException("Exception sending email, will rethrow in ServiceException to force transaction rollback if tx present", e);
        }
    }
}

