/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.document;

import com.anahata.util.compress.ZipUtils;
import com.anahata.util.reflect.AnahataPropertyUtils;
import com.anahata.yam.model.dms.TemplateDocument;
import com.anahata.yam.model.document.DocumentFormat;
import com.anahata.yam.model.template.model.DocumentDecorator;
import com.anahata.yam.model.template.model.DocumentModel;
import com.anahata.yam.service.document.DocmosisTemplateStore;
import com.anahata.yam.service.template.TemplateServiceLocal;
import com.anahata.yam.tech.ServerConfig;
import com.anahata.yam.tech.docmosis.HtmlDocumentPostProcessor;
import com.docmosis.document.DocumentProcessor;
import com.docmosis.document.RenderRequest;
import com.docmosis.document.converter.ConversionFormat;
import com.docmosis.document.converter.ConversionInstruction;
import com.docmosis.template.population.DataProvider;
import com.docmosis.template.population.DataProviderBuilder;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.template.store.TemplateStore;
import java.beans.ConstructorProperties;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Map;
import javax.ejb.LocalBean;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LocalBean
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class DocumentGenerationService {
    private static final Logger log = LoggerFactory.getLogger(DocumentGenerationService.class);
    @Inject
    private ServerConfig appConfig;
    @Inject
    private DocmosisTemplateStore templateStore;
    @Inject
    private TemplateServiceLocal templateServiceLocal;

    public byte[] renderHtml(DocumentModel templateModel) throws Exception {
        return this.render(templateModel, DocumentFormat.HTML_ZIP_WITH_IMAGES);
    }

    public byte[] render(DocumentModel documentModel, DocumentFormat format) throws Exception {
        log.debug("Rendering document decorator: {} with format {}", (Object)documentModel, (Object)format);
        DataProviderBuilder dpb = new DataProviderBuilder();
        String contentId = documentModel.getTemplateId();
        if (documentModel instanceof DocumentDecorator) {
            DocumentModel inner = ((DocumentDecorator)documentModel).getContent();
            dpb.addJavaObject((Object)inner);
            contentId = inner.getTemplateId();
            dpb.add("content", contentId);
            Map wrapperProperties = AnahataPropertyUtils.describe((Object)documentModel, DocumentDecorator.class, (boolean)false);
            for (String propertyName : wrapperProperties.keySet()) {
                Object javaObject = wrapperProperties.get(propertyName);
                log.trace("Adding JavaObject to DataProvider key={}, value={}", (Object)propertyName, javaObject);
                dpb.addJavaObject(javaObject, propertyName);
            }
        } else {
            dpb.addJavaObject((Object)documentModel);
        }
        TemplateDocument td = this.templateServiceLocal.findTemplateDocument(contentId);
        if (td != null) {
            dpb.add("templateNameVer", td.getTitle() + " v" + td.getDocmosisWorkingRevision().getNumber());
            dpb.add("templateDate", DateFormat.getDateTimeInstance(3, 3).format(td.getDocmosisWorkingRevision().getAddedOn()));
        }
        return this.render(documentModel.getTemplateId(), dpb, format);
    }

    public byte[] render(String id, DataProviderBuilder providerBuilder, DocumentFormat documentFormat) throws Exception {
        long ts = System.currentTimeMillis();
        ConversionFormat format = null;
        switch (documentFormat) {
            case HTML_ZIP_WITH_IMAGES: {
                format = ConversionFormat.FORMAT_HTML;
                break;
            }
            case HTML_EMBEDDED_IMAGES: {
                format = ConversionFormat.FORMAT_HTML;
                break;
            }
            case HTML_NOIMAGES: {
                format = ConversionFormat.FORMAT_HTML;
                break;
            }
            case PDF: {
                format = ConversionFormat.FORMAT_PDF;
                break;
            }
            case WORD: {
                format = ConversionFormat.FORMAT_WORD;
                break;
            }
            case TXT: {
                format = ConversionFormat.FORMAT_TEXT;
                break;
            }
            case ODT: {
                format = ConversionFormat.FORMAT_ODT;
                break;
            }
            case XHTML: {
                format = ConversionFormat.FORMAT_XHTML;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported document format " + documentFormat);
            }
        }
        providerBuilder.addJavaObject((Object)this.appConfig, "appConfig");
        TemplateIdentifier ti = new TemplateIdentifier(id);
        ConversionInstruction ci = new ConversionInstruction();
        ci.setConversionFormats(new ConversionFormat[]{format});
        RenderRequest rr = new RenderRequest();
        rr.setConversionInstruction(ci);
        rr.setTemplateStore((TemplateStore)this.templateStore);
        DataProvider dp = providerBuilder.getDataProvider();
        rr.setDataProvider(dp);
        rr.setTemplateIdentifier(ti);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        rr.setOutputStream((OutputStream)baos);
        if (DocumentFormat.HTML_ZIP_WITH_IMAGES == documentFormat) {
            ci.setCompressingSingleDocument(true);
        }
        log.debug("Callind DocumentProcessor.renderDoc");
        DocumentProcessor.renderDoc((RenderRequest)rr);
        log.debug("DocumentProcessor.renderDoc completed");
        byte[] ret = baos.toByteArray();
        if (documentFormat == DocumentFormat.HTML_ZIP_WITH_IMAGES) {
            log.debug("Post-processing HTML document");
            String html = ZipUtils.getString((byte[])ret, (String)".html");
            Validate.notNull((Object)html, (String)"Could not extract HTML from generated zip file", (Object[])new Object[0]);
            html = HtmlDocumentPostProcessor.processHtml(html);
            ret = ZipUtils.replaceString((byte[])ret, (String)".html", (String)html);
            log.debug("HTML post processing completed");
        } else if (format == ConversionFormat.FORMAT_HTML) {
            String html = HtmlDocumentPostProcessor.processHtml(new String(ret));
            ret = html.getBytes();
        }
        ts = System.currentTimeMillis() - ts;
        log.debug("Rendering {} took {}", (Object)id, (Object)ts);
        return ret;
    }

    public static DataProvider newProxy(DataProvider delegate) {
        return (DataProvider)Proxy.newProxyInstance(LoggingInvocationHandler.class.getClassLoader(), new Class[]{DataProvider.class}, (InvocationHandler)new LoggingInvocationHandler(delegate));
    }

    public ServerConfig getAppConfig() {
        return this.appConfig;
    }

    public static class LoggingInvocationHandler
    implements InvocationHandler {
        private static final Logger log = LoggerFactory.getLogger(LoggingInvocationHandler.class);
        DataProvider delegate;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            boolean isProxy;
            String sargs = "";
            if (args != null) {
                sargs = " arguments = " + Arrays.asList(args);
            }
            log.info("Calling {} {} on {}", new Object[]{method.getName(), sargs, this.delegate});
            Object ret = method.invoke((Object)this.delegate, args);
            if (ret instanceof DataProvider && (isProxy = Proxy.isProxyClass(ret.getClass()))) {
                System.out.println("returned object is a proxy " + ret);
                InvocationHandler handler = Proxy.getInvocationHandler(ret);
                System.out.println("returned object's handler " + handler);
                if (!(handler instanceof LoggingInvocationHandler)) {
                    System.out.println("wrapping " + ret + " as it is also a data provider");
                    ret = DocumentGenerationService.newProxy((DataProvider)ret);
                }
            }
            log.info("Call to {} {} on returned {}", new Object[]{method.getName(), sargs, this.delegate, ret});
            return ret;
        }

        @ConstructorProperties(value={"delegate"})
        public LoggingInvocationHandler(DataProvider delegate) {
            this.delegate = delegate;
        }
    }
}

