/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.document;

import com.anahata.yam.model.dms.TemplateDocument;
import com.anahata.yam.model.template.docmosis.DocmosisTemplateAdapter;
import com.anahata.yam.service.dms.storage.StorageService;
import com.anahata.yam.service.template.TemplateServiceLocal;
import com.anahata.yam.service.template.exception.TemplateInitialisationException;
import com.anahata.yam.tech.docmosis.TemplateStoreAdapter;
import com.docmosis.template.Template;
import com.docmosis.template.TemplateNotFoundException;
import com.docmosis.template.TemplateStoreException;
import com.docmosis.template.store.TemplateIdentifier;
import java.io.IOException;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class DocmosisTemplateStore
extends TemplateStoreAdapter {
    private static final Logger log = LoggerFactory.getLogger(DocmosisTemplateStore.class);
    @Inject
    private TemplateServiceLocal ejb;
    @Inject
    private StorageService storageService;

    public Template getTemplate(TemplateIdentifier paramTemplateIdentifier) throws IOException, TemplateNotFoundException, TemplateStoreException {
        try {
            TemplateDocument templateDocument = this.ejb.findTemplateDocument(paramTemplateIdentifier.getName());
            log.debug("found templateDocument= {}", (Object)templateDocument);
            if (templateDocument != null) {
                return new DocmosisTemplateAdapter(templateDocument, this.storageService);
            }
            log.debug("TemplateDocument not found trying to get template in old way.");
            com.anahata.yam.model.template.Template template = this.ejb.findTemplate(paramTemplateIdentifier.getName());
            return new DocmosisTemplateAdapter(template);
        }
        catch (TemplateInitialisationException e) {
            throw new TemplateStoreException("Exception initialising templates. Is docmosis up?", (Throwable)e);
        }
    }
}

