/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.dms.storage.setup;

import com.anahata.util.config.internal.ApplicationPropertiesFactory;
import com.anahata.util.lang.ResourceUtils;
import com.anahata.util.props.StructuredProperties;
import com.anahata.util.props.StructuredPropertyEntry;
import com.anahata.yam.model.dms.storage.StorageProvider;
import com.anahata.yam.tech.Yam;
import java.beans.PropertyDescriptor;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.ejb.Asynchronous;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Startup
public class AppPropertiesStorageProviderLoader {
    private static final Logger log = LoggerFactory.getLogger(AppPropertiesStorageProviderLoader.class);
    @Inject
    private ApplicationPropertiesFactory appPropsFactory;
    @Inject
    @Yam
    private EntityManager em;
    @EJB
    private AppPropertiesStorageProviderLoader self;

    @PostConstruct
    private void init() {
        this.self.load();
    }

    @Asynchronous
    public void load() {
        try {
            log.debug("Sleeping 10s to work around gf race condition on closed emf");
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.debug("Loading StorageProviders");
        Properties appProperties = this.appPropsFactory.getAppProperties();
        StructuredProperties props = new StructuredProperties(appProperties, new String[]{"yam", "dms", "storage"});
        String list = props.getString("providers", null);
        if (list != null) {
            String[] ids = list.split(",");
            int count = 0;
            for (String id : ids) {
                try {
                    String type = props.getString("provider." + id + ".class");
                    log.debug("Processing '{}' type: {}", (Object)id, (Object)type);
                    Class<?> clazz = Class.forName(type);
                    StorageProvider sp = (StorageProvider)clazz.newInstance();
                    List attributes = props.getStringList("provider." + id);
                    sp.setDownloadOrder((double)count);
                    for (StructuredPropertyEntry entry : attributes) {
                        PropertyDescriptor[] pds;
                        String propertyName = entry.getKey();
                        if (propertyName.equals("class")) continue;
                        Object val = entry.getValue();
                        for (PropertyDescriptor pd : pds = PropertyUtils.getPropertyDescriptors(sp.getClass())) {
                            log.debug("pd= {}" + pd);
                            log.debug("pd-name= {}" + pd.getName());
                        }
                        log.debug("propertyName= {}", (Object)propertyName);
                        log.debug("entry-key= {}", (Object)entry.getKey());
                        String key = entry.getKey();
                        if (key.endsWith(".file")) {
                            key = key.substring(0, propertyName.lastIndexOf(".file"));
                        }
                        log.debug("key= {}", (Object)key);
                        Class propType = PropertyUtils.getPropertyType((Object)sp, (String)key);
                        if (propertyName.endsWith(".file")) {
                            propertyName = propertyName.substring(0, propertyName.lastIndexOf(".file"));
                            log.debug("propName= {}, reading {} ", (Object)propertyName, val);
                            val = IOUtils.toString((URL)ResourceUtils.getResource((String)((String)val)));
                        }
                        log.debug("setting {} ({}) = {}", new Object[]{propertyName, propType, val});
                        BeanUtils.setProperty((Object)sp, (String)propertyName, (Object)val);
                    }
                    Validate.isTrue((sp.getId() != null ? 1 : 0) != 0, (String)"Id must be specified for storage provider %s ", (Object[])new Object[]{sp});
                    StorageProvider existing = (StorageProvider)this.em.find(StorageProvider.class, (Object)sp.getId());
                    if (existing == null) {
                        log.debug("Persisting: {}", (Object)sp);
                        this.em.persist((Object)sp);
                    } else {
                        log.debug("{} already in db", (Object)sp);
                    }
                    ++count;
                }
                catch (Exception e) {
                    log.warn("Exception adding storage providers");
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

