/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.dms.storage.client.spi.googledrive;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeRequestUrl;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.About;
import com.google.api.services.oauth2.Oauth2;
import com.google.api.services.oauth2.model.Userinfoplus;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GoogleDriveUtils {
    private static final Logger log = LoggerFactory.getLogger(GoogleDriveUtils.class);
    private static final String REDIRECT_URI = "urn:ietf:wg:oauth:2.0:oob";
    private static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    private static final JacksonFactory JSON_FACTORY = new JacksonFactory();
    private static final Map<String, Credential> store = new HashMap<String, Credential>();
    private static final List<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/drive.file", "https://www.googleapis.com/auth/userinfo.email", "https://www.googleapis.com/auth/userinfo.profile");
    private static GoogleAuthorizationCodeFlow flow = null;
    private static final File secretsFile = new File("<path-to-web-app>\\src\\main\\resources\\gdrive\\client-secrets.json");

    GoogleDriveUtils() {
    }

    static Credential getStoredCredentials(String userId) {
        return store.get(userId);
    }

    static void storeCredentials(String userId, Credential credentials) {
        store.put(userId, credentials);
    }

    static GoogleAuthorizationCodeFlow getFlow() throws IOException {
        if (flow == null && secretsFile.exists()) {
            FileInputStream is = new FileInputStream(secretsFile);
            InputStreamReader isr = new InputStreamReader(is);
            GoogleClientSecrets clientSecrets = GoogleClientSecrets.load((JsonFactory)JSON_FACTORY, (Reader)isr);
            flow = new GoogleAuthorizationCodeFlow.Builder(HTTP_TRANSPORT, (JsonFactory)JSON_FACTORY, clientSecrets, SCOPES).setAccessType("offline").setApprovalPrompt("force").build();
        }
        return flow;
    }

    static Drive buildService(GoogleCredential credentials) {
        NetHttpTransport httpTransport = new NetHttpTransport();
        JacksonFactory jsonFactory = new JacksonFactory();
        return new Drive.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, (HttpRequestInitializer)credentials).build();
    }

    static Credential exchangeCode(String authorizationCode) throws CodeExchangeException {
        try {
            GoogleAuthorizationCodeFlow flow = GoogleDriveUtils.getFlow();
            GoogleTokenResponse response = flow.newTokenRequest(authorizationCode).setRedirectUri(REDIRECT_URI).execute();
            return flow.createAndStoreCredential((TokenResponse)response, null);
        }
        catch (IOException e) {
            log.error("Error exchanging code. ", (Throwable)e);
            throw new CodeExchangeException(null);
        }
    }

    static Userinfoplus getUserInfo(Credential credentials) throws NoUserIdException {
        Oauth2 userInfoService = new Oauth2.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), (HttpRequestInitializer)credentials).build();
        Userinfoplus userInfo = null;
        try {
            userInfo = (Userinfoplus)userInfoService.userinfo().get().execute();
        }
        catch (IOException ex) {
            System.out.println("Error accoured.");
        }
        if (userInfo != null && userInfo.getId() != null) {
            return userInfo;
        }
        throw new NoUserIdException();
    }

    public static String getAuthorizationUrl(String emailAddress, String state) throws IOException {
        GoogleAuthorizationCodeRequestUrl urlBuilder = GoogleDriveUtils.getFlow().newAuthorizationUrl().setRedirectUri(REDIRECT_URI).setState(state);
        urlBuilder.set("user_id", (Object)emailAddress);
        return urlBuilder.build();
    }

    public static Credential getCredentials(String authorizationCode, String state) throws CodeExchangeException, NoRefreshTokenException, IOException {
        String emailAddress = "";
        try {
            Credential credentials = GoogleDriveUtils.exchangeCode(authorizationCode);
            Userinfoplus userInfo = GoogleDriveUtils.getUserInfo(credentials);
            String userId = userInfo.getId();
            emailAddress = userInfo.getEmail();
            if (credentials.getRefreshToken() != null) {
                GoogleDriveUtils.storeCredentials(userId, credentials);
                return credentials;
            }
            credentials = GoogleDriveUtils.getStoredCredentials(userId);
            if (credentials != null && credentials.getRefreshToken() != null) {
                return credentials;
            }
        }
        catch (CodeExchangeException e) {
            e.printStackTrace();
            e.setAuthorizationUrl(GoogleDriveUtils.getAuthorizationUrl(emailAddress, state));
            throw e;
        }
        catch (NoUserIdException e) {
            e.printStackTrace();
        }
        String authorizationUrl = GoogleDriveUtils.getAuthorizationUrl(emailAddress, state);
        throw new NoRefreshTokenException(authorizationUrl);
    }

    private static void getTokenJSON(String authCode) throws Exception {
        GoogleTokenResponse tokenResponse = flow.newTokenRequest(authCode).setRedirectUri(REDIRECT_URI).execute();
        String tokenJSONString = tokenResponse.toPrettyString();
        log.debug("token= {}\n", (Object)tokenJSONString);
        File temp = File.createTempFile("token", ".json");
        FileUtils.writeStringToFile((File)temp, (String)tokenJSONString);
        try {
            Desktop.getDesktop().open(temp);
        }
        catch (Exception e) {
            log.debug("Error in opening token json file ::", (Throwable)e);
        }
    }

    private static void printAboutDrive(String authCode, String state) throws Exception {
        try {
            Credential credential = GoogleDriveUtils.getCredentials(authCode, state);
            Drive drive = new Drive.Builder(HTTP_TRANSPORT, (JsonFactory)JSON_FACTORY, (HttpRequestInitializer)credential).build();
            About about = (About)drive.about().get().execute();
            System.out.println("Current user name: " + about.getName());
            System.out.println("Root folder ID: " + about.getRootFolderId());
            System.out.println("Total quota (bytes): " + about.getQuotaBytesTotal());
            System.out.println("Used quota (bytes): " + about.getQuotaBytesUsed());
        }
        catch (IOException e) {
            System.out.println("An error occurred: " + e);
        }
    }

    public static void main(String[] args) throws Exception {
        String state = "la la";
        String emailId = "<some-email>@gmail.com";
        String s = GoogleDriveUtils.getAuthorizationUrl("<some-email>@gmail.com", "la la");
        try {
            Desktop.getDesktop().browse(new URL(s).toURI());
        }
        catch (Exception e) {
            log.debug("Error in opening url ::", (Throwable)e);
        }
        String authCode = JOptionPane.showInputDialog("Enter Auth Code");
        GoogleDriveUtils.printAboutDrive(authCode, "la la");
    }

    private static class NoUserIdException
    extends Exception {
        private NoUserIdException() {
        }
    }

    public static class NoRefreshTokenException
    extends GetCredentialsException {
        public NoRefreshTokenException(String authorizationUrl) {
            super(authorizationUrl);
        }
    }

    public static class CodeExchangeException
    extends GetCredentialsException {
        public CodeExchangeException(String authorizationUrl) {
            super(authorizationUrl);
        }
    }

    public static class GetCredentialsException
    extends Exception {
        protected String authorizationUrl;

        public GetCredentialsException(String authorizationUrl) {
            this.authorizationUrl = authorizationUrl;
        }

        public void setAuthorizationUrl(String authorizationUrl) {
            this.authorizationUrl = authorizationUrl;
        }

        public String getAuthorizationUrl() {
            return this.authorizationUrl;
        }
    }
}

