/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.dms.storage.client.spi.googledrive;

import com.anahata.yam.model.dms.Document;
import com.anahata.yam.model.dms.Folder;
import com.anahata.yam.model.dms.Node;
import com.anahata.yam.model.dms.Revision;
import com.anahata.yam.model.dms.RevisionSynchStatus;
import com.anahata.yam.model.dms.storage.RevisionStorage;
import com.anahata.yam.model.dms.storage.StorageProvider;
import com.anahata.yam.model.dms.storage.spi.googledrive.GoogleDriveNodeStorage;
import com.anahata.yam.model.dms.storage.spi.googledrive.GoogleDriveRevisionStorage;
import com.anahata.yam.model.dms.storage.spi.googledrive.GoogleDriveStorageProvider;
import com.anahata.yam.service.dms.storage.NodeSynchService;
import com.anahata.yam.service.dms.storage.RevisionStream;
import com.anahata.yam.service.dms.storage.StorageService;
import com.anahata.yam.service.dms.storage.client.StorageProviderClient;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.apache.ApacheHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.client.util.DateTime;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.ParentReference;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleDriveStorageProviderClient
implements StorageProviderClient<GoogleDriveStorageProvider> {
    private static final Logger log = LoggerFactory.getLogger(GoogleDriveStorageProviderClient.class);
    public static final String FOLDER_MIME_TYPE = "application/vnd.google-apps.folder";
    private static final List<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/drive.file", "https://www.googleapis.com/auth/userinfo.email", "https://www.googleapis.com/auth/userinfo.profile");
    private Drive drive;
    private GoogleDriveStorageProvider provider;
    @Inject
    private StorageService storageService;
    @Inject
    private NodeSynchService nodeSynchService;

    @Override
    public Class<GoogleDriveStorageProvider> getProviderClass() {
        return GoogleDriveStorageProvider.class;
    }

    @Override
    public void init(GoogleDriveStorageProvider sp) throws IOException, GeneralSecurityException {
        this.provider = sp;
        long ts = System.currentTimeMillis();
        log.debug("Initializing drive client. rootFolderId {}", (Object)this.provider.getRootFolderId());
        ApacheHttpTransport httpTransport = new ApacheHttpTransport();
        JacksonFactory jsonFactory = new JacksonFactory();
        ByteArrayInputStream is = new ByteArrayInputStream(this.provider.getClientSecrets().getBytes());
        InputStreamReader reader = new InputStreamReader(is);
        GoogleClientSecrets clientSecrets = GoogleClientSecrets.load((JsonFactory)jsonFactory, (Reader)reader);
        GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, clientSecrets, SCOPES).setAccessType("offline").setApprovalPrompt("force").build();
        GoogleTokenResponse tokenResponse = (GoogleTokenResponse)jsonFactory.fromString(this.provider.getTokens(), GoogleTokenResponse.class);
        Credential credential = flow.createAndStoreCredential((TokenResponse)tokenResponse, this.provider.getAccountId());
        this.drive = new Drive.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, (HttpRequestInitializer)credential).build();
        ts = System.currentTimeMillis() - ts;
        log.info("Initialized drive client in {}. rootFolderId {}", (Object)ts, (Object)this.provider.getRootFolderId());
    }

    @Override
    public void synch(Node node) throws Exception {
        Document doc;
        File driveFile;
        boolean newDriveNode;
        String parentId;
        log.debug("synch begins for node {}", (Object)node);
        Folder parent = node.getParent();
        if (parent == null) {
            parentId = this.provider.getRootFolderId();
        } else {
            GoogleDriveNodeStorage parentStorage = (GoogleDriveNodeStorage)parent.getNodeStorage((StorageProvider)this.provider);
            parentId = parentStorage.getFileId();
        }
        GoogleDriveNodeStorage nodeStorage = (GoogleDriveNodeStorage)node.getNodeStorage((StorageProvider)this.provider);
        log.debug("Got nodeStorage for node {}, parentId={}", (Object)node, (Object)parentId);
        Date synchedOn = new Date();
        boolean bl = newDriveNode = nodeStorage.getFileId() == null;
        if (newDriveNode) {
            if (node.isRemoved()) {
                log.debug("Not adding node {} as it is been removed and it has no entry on the node storage", (Object)node);
                return;
            }
            if (node instanceof Folder) {
                driveFile = this.toDriveFile((Node)((Folder)node), parentId, true);
                log.debug("creating folder on google drive for {}", (Object)node.getTitle());
                driveFile = (File)this.drive.files().insert(driveFile).execute();
                log.debug("Google drive folder created for {}. Goole drive fileId:", (Object)node.getTitle(), (Object)driveFile.getId());
                nodeStorage.setFileId(driveFile.getId());
                nodeStorage = this.nodeSynchService.updateNodeStorage(nodeStorage);
            } else if (node instanceof Document) {
                doc = (Document)node;
                Revision firstRevision = doc.getFirstRevision();
                driveFile = this.toDriveFile(firstRevision, parentId);
                log.debug("creating file on google drive for {}", (Object)node.getTitle());
                try (RevisionStream revisionDownload = this.storageService.getRevisionStream(firstRevision.getId());){
                    driveFile = (File)this.drive.files().insert(driveFile, (AbstractInputStreamContent)new InputStreamContent(firstRevision.getMimeType(), revisionDownload.getInputStream())).execute();
                }
                log.debug("Google drive file created for {}. Goole drive fileId: {}. Fetching head revision Id", (Object)node.getTitle(), (Object)driveFile.getId());
                String headRevisionId = ((File)this.drive.files().get(driveFile.getId()).setFields("headRevisionId").execute()).getHeadRevisionId();
                this.pinRevision(driveFile.getId(), headRevisionId);
                GoogleDriveRevisionStorage revisionStorage = new GoogleDriveRevisionStorage(this.provider, firstRevision);
                firstRevision.getStorage().add(revisionStorage);
                log.debug("After insert of {} fileId {}, headRevisionId = {} ", new Object[]{node.getTitle(), driveFile.getId(), headRevisionId});
                revisionStorage.setRevisionId(headRevisionId);
                revisionStorage.setSynchedOn(synchedOn);
                log.debug("created revisionStorage {} for {} on provider {}", new Object[]{revisionStorage, node, this.provider});
                nodeStorage.setFileId(driveFile.getId());
                nodeStorage = (GoogleDriveNodeStorage)this.nodeSynchService.updateNodeStorageAndAddRevisionStorage(nodeStorage, firstRevision, revisionStorage);
            }
            if (node.isTrashed()) {
                log.debug("trashing new node {} on provider {}", (Object)node, (Object)this.provider);
                this.drive.files().trash(nodeStorage.getFileId()).execute();
            }
        } else {
            boolean trashedInDrive;
            if (node.isRemoved()) {
                if (node instanceof Document) {
                    for (Revision r : ((Document)node).getRevisions()) {
                        for (Revision copy : r.getCopies()) {
                            if (copy.getSynchStatus() == RevisionSynchStatus.UPLOADED) continue;
                            throw new IllegalStateException("Not synching hard delete of document " + node + " As revision " + copy + " is still in " + copy.getSynchStatus());
                        }
                    }
                }
                log.debug("Removing node {} from  {}", (Object)node, (Object)this.provider);
                this.drive.files().delete(nodeStorage.getFileId());
                return;
            }
            driveFile = this.toDriveFile(node, parentId, false);
            log.debug("patching node {} on provider {}, fileid={}, file=", new Object[]{node, this.provider, driveFile.getId(), driveFile});
            Drive.Files.Patch patch = this.drive.files().patch(nodeStorage.getFileId(), driveFile);
            patch.setFields("explicitlyTrashed");
            driveFile = (File)patch.execute();
            log.debug("after patch {} explicitelyTrashed {}", (Object)driveFile, (Object)driveFile.getExplicitlyTrashed());
            log.debug("file {} for node {} on provider {}", new Object[]{driveFile, node, this.provider});
            log.debug("{} trashed {}, trashed in drive {}", new Object[]{node, node.isTrashed(), driveFile.getExplicitlyTrashed()});
            boolean bl2 = trashedInDrive = driveFile.getExplicitlyTrashed() != null && driveFile.getExplicitlyTrashed() != false;
            if (node.isTrashed() && !trashedInDrive) {
                log.debug("trashing node {} on provider {}", (Object)node, (Object)this.provider);
                this.drive.files().trash(nodeStorage.getFileId()).execute();
            } else if (!node.isTrashed() && trashedInDrive) {
                log.debug("untrashing node {} on provider {}", (Object)node, (Object)this.provider);
                this.drive.files().untrash(nodeStorage.getFileId());
            }
        }
        log.debug("google drive synch completed for node {}, synchedChange = {}", (Object)node, (Object)node.getChangedOn());
        if (node instanceof Document && (doc = (Document)node).getRevisions().size() > 1) {
            for (int i = 1; i < doc.getRevisions().size(); ++i) {
                Revision revision = (Revision)doc.getRevisions().get(i);
                if (revision.isSynched((StorageProvider)this.provider)) continue;
                driveFile = this.toDriveFile(revision, parentId);
                try (RevisionStream revisionDownload = this.storageService.getRevisionStream(revision);){
                    log.debug("adding revision {} on google drive for yam document {}", (Object)revision, (Object)doc.getTitle());
                    driveFile = (File)this.drive.files().update(nodeStorage.getFileId(), driveFile, (AbstractInputStreamContent)new InputStreamContent(revision.getMimeType(), revisionDownload.getInputStream())).setFields("headRevisionId").execute();
                    log.debug("revision {} added to google drive for yam document {}", new Object[]{revision, doc.getTitle(), "getting revision id"});
                    String headRevisionId = driveFile.getHeadRevisionId();
                    log.debug("Added revision for {} google id = {}, drive headRevisionId is now {} ", new Object[]{node.getTitle(), nodeStorage.getFileId(), headRevisionId});
                    this.pinRevision(nodeStorage.getFileId(), headRevisionId);
                    GoogleDriveRevisionStorage revisionStorage = new GoogleDriveRevisionStorage(this.provider, revision);
                    revision.getStorage().add(revisionStorage);
                    revisionStorage.setRevisionId(headRevisionId);
                    revisionStorage.setSynchedOn(synchedOn);
                    this.nodeSynchService.addRevisionStorage(revision, (RevisionStorage)revisionStorage);
                    continue;
                }
            }
        }
        log.debug("synch finished for node {}", (Object)node);
    }

    private void pinRevision(String fileId, String revisionId) throws IOException {
        log.debug("pinning revision {} ", (Object)revisionId);
        com.google.api.services.drive.model.Revision r = new com.google.api.services.drive.model.Revision();
        r.setPinned(Boolean.TRUE);
        this.drive.revisions().patch(fileId, revisionId, r).execute();
        log.debug("revision pinned {} ", (Object)revisionId);
    }

    private File toDriveFile(@NonNull Node node, @NonNull String parentId, boolean setCreatedDate) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (parentId == null) {
            throw new NullPointerException("parentId");
        }
        File file = new File();
        file.setTitle(node.getTitle());
        file.setDescription(node.getNotes());
        if (setCreatedDate) {
            file.setCreatedDate(new DateTime(node.getCreatedOn()));
        }
        if (node.getModifiedOn() != null) {
            file.setModifiedDate(new DateTime(node.getModifiedOn()));
        }
        if (node instanceof Folder) {
            file.setMimeType(FOLDER_MIME_TYPE);
        } else {
            file.setMimeType(node.getMimeType());
        }
        ParentReference ref = new ParentReference();
        ref.setId(parentId);
        file.setParents(Collections.singletonList(ref));
        return file;
    }

    private File toDriveFile(@NonNull Revision rev, @NonNull String parentId) {
        if (rev == null) {
            throw new NullPointerException("rev");
        }
        if (parentId == null) {
            throw new NullPointerException("parentId");
        }
        File file = this.toDriveFile((Node)rev.getDocument(), parentId, true);
        if (!rev.isHead()) {
            file.setModifiedDate(new DateTime(rev.getModifiedOn()));
            file.setTitle(rev.getFileName());
        }
        file.setOriginalFilename(rev.getFileName());
        return file;
    }

    @Override
    public RevisionStream getRevisionContent(Revision rev) throws Exception {
        GoogleDriveRevisionStorage revisionStorage = (GoogleDriveRevisionStorage)rev.getRevisionStorage((StorageProvider)this.provider);
        if (revisionStorage != null) {
            String fileId = revisionStorage.getFileId();
            String revId = revisionStorage.getRevisionId();
            File file = (File)this.drive.files().get(fileId).execute();
            String downloadURL = file.getHeadRevisionId().equals(revisionStorage.getRevisionId()) ? file.getDownloadUrl() : ((com.google.api.services.drive.model.Revision)this.drive.revisions().get(fileId, revId).execute()).getDownloadUrl();
            return this.newStream(downloadURL);
        }
        return null;
    }

    private RevisionStream newStream(final String downloadURL) throws IOException {
        final HttpResponse resp = this.drive.getRequestFactory().buildGetRequest(new GenericUrl(downloadURL)).execute();
        return new RevisionStream(resp.getContent()){

            public void close() {
                try {
                    resp.getContent().close();
                    resp.disconnect();
                }
                catch (Exception e) {
                    log.warn("Exception closing google drive input stream for url" + downloadURL, (Throwable)e);
                }
            }
        };
    }

    @Override
    public RevisionStream getThumbnail(Revision rev, int fitWidth, int fitHeight) throws Exception {
        if (!rev.isHead()) {
            log.debug("{} is Not the head revision so google drive cannot provide tn, head revision is {}", (Object)rev, (Object)rev.getDocument().getHeadRevision());
            return null;
        }
        log.debug("{} Is the head revision so will request thumb from drive", (Object)rev);
        GoogleDriveNodeStorage nodeStorage = (GoogleDriveNodeStorage)rev.getDocument().getNodeStorage((StorageProvider)this.provider);
        if (nodeStorage != null) {
            String fileId = nodeStorage.getFileId();
            File file = (File)this.drive.files().get(fileId).setFields("thumbnailLink").execute();
            if (file.getThumbnailLink() != null) {
                String url = file.getThumbnailLink();
                log.debug("thumbnail url: {}", (Object)url);
                url = url.substring(0, url.lastIndexOf("=s"));
                url = url + "=s" + Math.max(fitWidth, fitHeight);
                log.debug("thumbnail patched url: {}", (Object)url);
                return this.newStream(url);
            }
            log.debug("no thumbnail available for: {}", (Object)rev);
            return null;
        }
        log.debug("No node storage for revision {} which doesn't make sense", (Object)rev);
        return null;
    }

    @Override
    public GoogleDriveStorageProvider getProvider() {
        return this.provider;
    }
}

