/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.dms.storage.client.spi.file;

import com.anahata.yam.model.dms.Document;
import com.anahata.yam.model.dms.Node;
import com.anahata.yam.model.dms.Revision;
import com.anahata.yam.model.dms.RevisionSynchStatus;
import com.anahata.yam.model.dms.storage.NodeStorage;
import com.anahata.yam.model.dms.storage.RevisionStorage;
import com.anahata.yam.model.dms.storage.StorageProvider;
import com.anahata.yam.model.dms.storage.spi.file.FileRevisionStorage;
import com.anahata.yam.model.dms.storage.spi.file.FileStorageProvider;
import com.anahata.yam.service.dms.storage.NodeSynchService;
import com.anahata.yam.service.dms.storage.RevisionStream;
import com.anahata.yam.service.dms.storage.StorageService;
import com.anahata.yam.service.dms.storage.client.StorageProviderClient;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStorageProviderClient
implements StorageProviderClient<FileStorageProvider> {
    private static final Logger log = LoggerFactory.getLogger(FileStorageProviderClient.class);
    private FileStorageProvider provider;
    private File dir;
    @Inject
    private StorageService storageService;
    @Inject
    private NodeSynchService nodeSynchService;

    @Override
    public Class<FileStorageProvider> getProviderClass() {
        return FileStorageProvider.class;
    }

    @Override
    public FileStorageProvider getProvider() {
        return this.provider;
    }

    @Override
    public void init(FileStorageProvider storageProvider) throws Exception {
        this.provider = storageProvider;
        this.dir = new File(this.provider.getFolder());
        this.dir.mkdirs();
    }

    @Override
    public void synch(Node node) throws Exception {
        NodeStorage ns = node.getNodeStorage((StorageProvider)this.provider);
        Validate.notNull((Object)ns, (String)"Node storage not initialized for %s on provider %s", (Object[])new Object[]{node, this.provider});
        if (node instanceof Document) {
            Document doc = (Document)node;
            for (Revision revision : doc.getRevisions()) {
                log.debug("Checking synch status of revision {}", (Object)revision);
                if (!revision.isSynched((StorageProvider)this.provider)) {
                    if (!revision.isRemoved()) {
                        File temp = File.createTempFile("yam-dms-revision-download", revision.getId());
                        temp.deleteOnExit();
                        try (RevisionStream revisionDownload = this.storageService.getRevisionStream(revision.getId());
                             FileOutputStream fos = new FileOutputStream(temp);){
                            IOUtils.copy((InputStream)revisionDownload.getInputStream(), (OutputStream)fos);
                        }
                        if (this.getTarget(revision).exists()) {
                            this.getTarget(revision).delete();
                        }
                        log.debug("Copying revision content of {} to {}", (Object)revision, (Object)this.getTarget(revision));
                        temp.renameTo(this.getTarget(revision));
                    }
                    FileRevisionStorage frs = new FileRevisionStorage(this.provider, revision);
                    revision.getStorage().add(frs);
                    frs.setSynchedOn(new Date());
                    this.nodeSynchService.addRevisionStorage(revision, (RevisionStorage)frs);
                }
                if (!revision.isSynched((StorageProvider)this.provider) || !this.getTarget(revision).exists() || !revision.isRemoved()) continue;
                for (Revision copy : revision.getCopies()) {
                    if (copy.getSynchStatus() == RevisionSynchStatus.UPLOADED) continue;
                    throw new IllegalStateException("Not synching hard delete of revision " + revision + " As revision " + copy + " is still in " + copy.getSynchStatus());
                }
                log.debug("Hard deleting revision {} from {}", (Object)revision, (Object)this.getTarget(revision));
                this.getTarget(revision).delete();
            }
        }
    }

    private File getTarget(Revision revision) {
        File target = new File(this.dir, revision.getId());
        return target;
    }

    @Override
    public RevisionStream getRevisionContent(Revision rev) throws Exception {
        FileInputStream is = new FileInputStream(this.getTarget(rev));
        return new RevisionStream((InputStream)is);
    }

    @Override
    public RevisionStream getThumbnail(Revision rev, int fitWidth, int fitHeight) throws Exception {
        if (rev.isImage()) {
            byte[] barr = Revision.makeThumbnail((Revision)rev, (InputStream)new FileInputStream(this.getTarget(rev)), (int)fitWidth, (int)fitHeight);
            return new RevisionStream((InputStream)new ByteArrayInputStream(barr));
        }
        return null;
    }
}

