/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.dms.storage.client;

import com.anahata.util.cdi.Cdi;
import com.anahata.yam.model.dms.storage.StorageProvider;
import com.anahata.yam.service.dms.storage.client.StorageProviderClient;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class StorageProviderClientFactory {
    private static final Logger log = LoggerFactory.getLogger(StorageProviderClientFactory.class);
    @Inject
    @Default
    private Instance<StorageProviderClient<? extends StorageProvider>> adapterFactory;
    private final Map<StorageProvider, StorageProviderClient> services = new HashMap<StorageProvider, StorageProviderClient>();

    public synchronized <T extends StorageProvider> StorageProviderClient<T> getAdapter(@NonNull StorageProvider provider) throws Exception {
        if (provider == null) {
            throw new NullPointerException("provider");
        }
        StorageProviderClient existing = this.services.get(provider);
        if (existing != null && !existing.getProvider().getLastModified().equals(provider.getLastModified())) {
            this.services.remove(provider);
            existing = null;
        }
        if (existing != null) {
            return existing;
        }
        return this.makeService(provider);
    }

    private StorageProviderClient makeService(StorageProvider sp) throws Exception {
        for (StorageProviderClient storageProviderService : this.adapterFactory) {
            if (!storageProviderService.getProviderClass().equals(sp.getClass())) continue;
            StorageProviderClient instance = (StorageProviderClient)Cdi.get(storageProviderService.getClass(), (Annotation[])new Annotation[0]);
            log.debug("Calling {}.init({})", (Object)instance, (Object)sp);
            instance.init(sp);
            log.debug("Completed {}.init({})", (Object)instance, (Object)sp);
            this.services.put(sp, instance);
            return storageProviderService;
        }
        throw new IllegalArgumentException("No service class found for " + sp);
    }
}

