/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.dms.storage;

import com.anahata.util.validation.ValidationUtils;
import com.anahata.yam.model.dms.RevisionSynchStatus;
import com.anahata.yam.model.dms.storage.NodeStorage;
import com.anahata.yam.model.dms.storage.StorageProvider;
import com.anahata.yam.service.dms.storage.NodeSynchService;
import com.anahata.yam.service.dms.storage.StorageProviderService;
import com.anahata.yam.service.dms.storage.client.StorageProviderClient;
import com.anahata.yam.service.dms.storage.client.StorageProviderClientFactory;
import com.anahata.yam.tech.ServerConfig;
import com.anahata.yam.tech.Yam;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.Timer;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class StorageSynchBatch {
    private static final Logger log = LoggerFactory.getLogger(StorageSynchBatch.class);
    @Inject
    @Yam
    private EntityManager em;
    @EJB
    private NodeSynchService nodeSynch;
    @EJB
    private StorageProviderService sps;
    @Inject
    private ServerConfig sc;
    @Inject
    private StorageProviderClientFactory adapterFactory;
    private boolean checkOld = true;

    @Schedule(minute="*", second="*/10", dayOfMonth="*", month="*", year="*", hour="*", dayOfWeek="*", persistent=false)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    void synchRecent(Timer timer) {
        if (!this.sc.isDmsEnabled() || !this.sc.isBatchJobsEnabled()) {
            log.debug("StorageSynchBatch recent cancelled as dms or batch jobs not enabled");
            timer.cancel();
            return;
        }
        try {
            this.doSync();
        }
        catch (Throwable e) {
            log.error("Exception syncing revision storage", e);
        }
    }

    @Schedule(minute="*/5", second="0", dayOfMonth="*", month="*", year="*", hour="*", dayOfWeek="*", persistent=false)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    void checkOldData(Timer timer) {
        if (!this.sc.isDmsEnabled() || !this.sc.isBatchJobsEnabled()) {
            log.debug("StorageSynchBatch old data check cancelled as dms or batch jobs not enabled");
            timer.cancel();
            return;
        }
        log.debug("checkOldData timer setting checkOldData to true, was {}", (Object)this.checkOld);
        this.checkOld = true;
    }

    private void doSync() {
        boolean checkOldLocal = this.checkOld;
        log.debug("doSync starts checkOld={}", (Object)checkOldLocal);
        boolean oldFound = false;
        List<StorageProvider> activeProviders = this.sps.getActiveProviders();
        this.em.clear();
        for (StorageProvider provider : activeProviders) {
            try {
                StorageProviderClient client = this.adapterFactory.getAdapter(provider);
                log.debug("Querying nodes for synching on {}", (Object)provider);
                List<Long> nodes = this.getNodesPendingSynch(provider, checkOldLocal);
                log.debug("{} New nodes for synching on {}: {}", new Object[]{nodes.size(), provider, nodes});
                this.em.clear();
                for (Long nodeId : nodes) {
                    log.debug("Initializing synch of node {} on provider {}", (Object)nodeId, (Object)provider);
                    NodeStorage nodeStorage = this.nodeSynch.initNodeStorage(provider, nodeId);
                    log.debug("Initialized synch of node {} on provider {}", (Object)nodeId, (Object)provider);
                    if (nodeStorage != null) {
                        if (nodeStorage.getNode().getChangedOn().before(this.getOldDataDate())) {
                            log.debug("Old Data Found in Node {} : {} on provider {} setting oldFound to true, was {}", new Object[]{nodeId, nodeStorage.getNode(), oldFound});
                            oldFound = true;
                        }
                        log.debug("Launching synch of node {} : {} on provider {}", new Object[]{nodeId, nodeStorage.getNode(), provider});
                        this.nodeSynch.synch(client, nodeStorage);
                        log.debug("Launched synch of node {} : {} on provider {}", new Object[]{nodeId, nodeStorage.getNode(), provider});
                        continue;
                    }
                    log.debug("Node storage did not initialize for node {} on provider {}", (Object)nodeId, (Object)provider);
                }
            }
            catch (Throwable e) {
                String s = ValidationUtils.getConstraintValidationDetails((Throwable)e);
                log.warn("Exception synching provider " + provider + " " + s, e);
            }
        }
        log.debug("doSync completed, old data found =" + oldFound);
        if (oldFound) {
            log.debug("Old data found, preserving checkOld flag");
            this.checkOld = true;
        } else if (checkOldLocal && !oldFound) {
            log.debug("Old data not found while looking for old data, setting checkOld = false");
            this.checkOld = false;
        }
    }

    private Date getOldDataDate() {
        return DateUtils.addMonths((Date)new Date(), (int)-1);
    }

    private Number getSynchingNodeCount(StorageProvider sp, Date synchBeatExpiry) {
        log.debug("synchBeatExpiry={}", (Object)synchBeatExpiry);
        Number number = (Number)this.em.createQuery("Select COUNT(ns) From NodeStorage ns WHERE   ns.provider = :sp AND   ns.synchStart IS NOT NULL AND   ns.synchBeat > :synchBeatExpiry").setParameter("synchBeatExpiry", (Object)synchBeatExpiry).setParameter("sp", (Object)sp).getSingleResult();
        log.debug("Nodes currently synching as per db on {}: {}", (Object)sp, (Object)number);
        return number;
    }

    private List<Long> getNodesPendingSynch(StorageProvider sp, boolean checkOldLocal) {
        Date synchBeatExpiry = DateUtils.addSeconds((Date)new Date(), (int)-30);
        Number number = this.getSynchingNodeCount(sp, synchBeatExpiry);
        int maxNodes = 10 - number.intValue();
        log.debug("maxNodes={}", (Object)maxNodes);
        if (maxNodes <= 0) {
            log.debug("maxNodes reached. returning empty list");
            return Collections.EMPTY_LIST;
        }
        long ts = System.currentTimeMillis();
        String sql = "Select distinct(n.id) From Node n left join n.parent parent WHERE " + (checkOldLocal ? "" : " n.changedOn >= :oldDataDate AND  ") + " ( " + "  (NOT EXISTS (Select ns FROM NodeStorage ns WHERE ns.node = n and ns.provider = :sp))" + "  OR " + "   ((Select MAX(ns.synchedChange) " + "                     FROM NodeStorage ns " + "                     WHERE ns.node = n and ns.provider = :sp " + "  ) IS NULL)" + "  OR" + "  (n.changedOn > (Select MAX(ns.synchedChange) " + "                     FROM NodeStorage ns " + "                     WHERE ns.node = n and ns.provider = :sp " + "                  )" + "  )" + " )" + " AND " + " (" + "  NOT EXISTS (Select ns FROM NodeStorage ns WHERE ns.node = n and ns.provider = :sp and ns.synchBeat > :synchBeatExpiry)" + " )" + " AND " + " (" + "  NOT EXISTS (Select r.id from Revision r where r.synchStatus != :uploaded AND r.document.id = n.id)" + " )" + " AND" + " ( " + "  (parent IS NULL) " + "  OR " + "  (parent.changedOn = (Select MAX(ns.synchedChange) FROM NodeStorage ns WHERE ns.node = parent and ns.provider = :sp))" + " )" + " ORDER BY n.changedOn ASC";
        Query q = this.em.createQuery(sql);
        q.setParameter("sp", (Object)sp);
        q.setParameter("uploaded", (Object)RevisionSynchStatus.UPLOADED);
        q.setParameter("synchBeatExpiry", (Object)synchBeatExpiry);
        q.setMaxResults(maxNodes);
        if (!checkOldLocal) {
            q.setParameter("oldDataDate", (Object)this.getOldDataDate());
        }
        List ret = q.getResultList();
        ts = System.currentTimeMillis() - ts;
        log.debug("getNodesPendingSynch({}) checkOld= {} took {} ms.", new Object[]{sp, checkOldLocal, ts});
        return ret;
    }
}

