/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.dms.storage;

import com.anahata.yam.model.dms.Revision;
import com.anahata.yam.model.dms.RevisionSynchStatus;
import com.anahata.yam.model.dms.storage.RevisionStorage;
import com.anahata.yam.model.dms.storage.StorageProvider;
import com.anahata.yam.service.dms.storage.ByteArrayRevisionStream;
import com.anahata.yam.service.dms.storage.RevisionStream;
import com.anahata.yam.service.dms.storage.StorageProviderService;
import com.anahata.yam.service.dms.storage.StorageService;
import com.anahata.yam.service.dms.storage.client.StorageProviderClient;
import com.anahata.yam.service.dms.storage.client.StorageProviderClientFactory;
import com.anahata.yam.tech.Yam;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import lombok.NonNull;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class StorageServiceImpl
implements StorageService {
    private static final Logger log = LoggerFactory.getLogger(StorageServiceImpl.class);
    private static final int RETRY_COUNT = 3;
    @Inject
    private StorageProviderService providerService;
    @Inject
    @Yam
    private EntityManager em;
    @Inject
    @Default
    private StorageProviderClientFactory clientFactory;

    public byte[] getRevisionBytes(Revision revision) throws IOException {
        try (RevisionStream rs = this.getRevisionStream(revision);){
            byte[] ret;
            byte[] byArray = ret = IOUtils.toByteArray((InputStream)rs.getInputStream());
            return byArray;
        }
    }

    public RevisionStream getRevisionStream(String id) {
        return this.getRevisionStream((Revision)this.em.find(Revision.class, (Object)id));
    }

    public RevisionStream getRevisionStream(@NonNull Revision revision) {
        if (revision == null) {
            throw new NullPointerException("revision");
        }
        revision = StorageServiceImpl.getDownloadableRevision(revision);
        Validate.isTrue((boolean)revision.isUploaded(), (String)("Revision " + revision + " has not yet being uploaded"), (Object[])new Object[0]);
        if (revision.getBytes() != null) {
            return new ByteArrayRevisionStream(revision.getBytes());
        }
        RevisionStream rs = this.getStream(revision, new RevisionStreamProvider(){

            @Override
            public RevisionStream getStream(Revision currentRevision, StorageProviderClient client) throws Exception {
                return client.getRevisionContent(currentRevision);
            }
        }, "revision content");
        if (rs == null) {
            throw new IllegalStateException("Could not fetch revision stream for " + revision);
        }
        return rs;
    }

    public RevisionStream getThumbnailStream(Revision revision, final int fitWidth, final int fitHeight) {
        revision = StorageServiceImpl.getDownloadableRevision(revision);
        Validate.isTrue((boolean)revision.isUploaded(), (String)("Revision " + revision + " has not yet being uploaded"), (Object[])new Object[0]);
        if (revision.getBytes() != null && revision.isImage() && revision.isPdf()) {
            try {
                byte[] thumb = revision.isImage() ? revision.getThumbnail(fitWidth, fitHeight) : revision.getThumbnailForPdf(fitWidth, fitHeight);
                return new ByteArrayRevisionStream(thumb);
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                log.warn("Could not create direct thumbnail of " + (revision.isImage() ? "image" : "pdf") + " " + revision.getFileName(), (Throwable)e);
            }
        }
        return this.getStream(revision, new RevisionStreamProvider(){

            @Override
            public RevisionStream getStream(Revision currentRevision, StorageProviderClient client) throws Exception {
                return client.getThumbnail(currentRevision, fitWidth, fitHeight);
            }
        }, "thumbnail");
    }

    private RevisionStream getStream(Revision revision, RevisionStreamProvider provider, String content) {
        revision = StorageServiceImpl.getDownloadableRevision(revision);
        Validate.isTrue((boolean)revision.isUploaded(), (String)("Revision " + revision + " has not yet being uploaded and it is not a copy of another revision that has been uploaded already"), (Object[])new Object[0]);
        List<StorageProvider> providers = this.providerService.getActiveProviders();
        block2: for (StorageProvider storageProvider : providers) {
            log.debug("Attempting to fecth {} from provider {} for revision {}", new Object[]{content, storageProvider, revision.getFileName()});
            RevisionStorage rs = revision.getRevisionStorage(storageProvider);
            if (rs == null) continue;
            log.debug("Got RevisionStorage {} when attempting to fetch{} from provider {} for revision {}", new Object[]{rs, content, storageProvider, revision.getFileName()});
            for (int attempt = 0; attempt < 3; ++attempt) {
                try {
                    StorageProviderClient client = this.clientFactory.getAdapter(storageProvider);
                    RevisionStream is = provider.getStream(revision, client);
                    if (is != null) {
                        return is;
                    }
                    log.warn("Got null {} RevisionStream for provider = {}, revision={}, assuming provider does not support it", new Object[]{content, storageProvider, revision.getFileName(), attempt});
                    continue block2;
                }
                catch (Exception e) {
                    log.warn("Exception getting " + content + " RevisionStream from provider: " + storageProvider + " attempt=" + attempt, (Throwable)e);
                    continue;
                }
            }
        }
        return null;
    }

    private static Revision getDownloadableRevision(Revision revision) {
        if (revision.getSynchStatus() == RevisionSynchStatus.PENDING_COPY) {
            while (revision.getCopyOf() != null) {
                if (revision.getCopyOf().getSynchStatus() == RevisionSynchStatus.UPLOADED && !revision.getCopyOf().getDocument().isRemoved()) {
                    log.info("Using {} as source as it is in UPLOADED status while {} is in PENDING_COPY status", (Object)revision.getCopyOf(), (Object)revision);
                    return revision.getCopyOf();
                }
                revision = revision.getCopyOf();
            }
        }
        return revision;
    }

    private static interface RevisionStreamProvider {
        public RevisionStream getStream(Revision var1, StorageProviderClient var2) throws Exception;
    }
}

