/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.dms.storage;

import com.anahata.yam.model.dms.Revision;
import com.anahata.yam.model.dms.storage.StorageProvider;
import com.anahata.yam.service.dms.storage.StorageProviderService;
import com.anahata.yam.tech.ServerConfig;
import com.anahata.yam.tech.Yam;
import java.util.List;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.Timer;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class RevisionDataCleanupBatch {
    private static final Logger log = LoggerFactory.getLogger(RevisionDataCleanupBatch.class);
    @Inject
    @Yam
    private EntityManager em;
    @Inject
    private ServerConfig serverConfig;
    @Inject
    private StorageProviderService sps;

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @Schedule(minute="*", second="0", dayOfMonth="*", month="*", year="*", hour="*", dayOfWeek="*", persistent=false)
    void deleteRevisionData(Timer timer) {
        try {
            this.doClean(timer);
        }
        catch (Throwable e) {
            log.error("Exception cleaning revision data", e);
        }
    }

    private void doClean(Timer timer) {
        log.debug("freeing revision data");
        if (!(this.serverConfig.isDmsEnabled() && this.serverConfig.isDmsRevisionDataCleanupEnabled() && this.serverConfig.isBatchJobsEnabled())) {
            log.debug("dms.revision.data.cleanup.enabled = false in ServerConfig, cancelling timer");
            timer.cancel();
            return;
        }
        List<StorageProvider> activeProviders = this.sps.getActiveProviders();
        if (activeProviders.isEmpty()) {
            log.debug("no active providers, returning");
            return;
        }
        String query = "Select r From Revision r WHERE r.data IS NOT NULL AND    (SELECT COUNT(rs) FROM RevisionStorage rs     WHERE rs.revision = r AND rs.provider.active = true)  = (SELECT COUNT(sp) FROM StorageProvider sp     WHERE sp.active = true)";
        long ts = System.currentTimeMillis();
        List revisions = this.em.createQuery(query).setMaxResults(20).getResultList();
        log.debug("Revisions with data offloaded to all active storage providers: {}", (Object)revisions.size());
        for (Revision revision : revisions) {
            log.debug("Clearing data for revision {}", (Object)revision);
            revision.clearData();
        }
        this.em.flush();
        ts = System.currentTimeMillis() - ts;
        log.debug("Unlinkging RevisionData from revisions that had been offloaded to all active StorageProviders took {} ms", (Object)ts);
        long ts2 = System.currentTimeMillis();
        String deleteRevisionData = "DELETE FROM RevisionData rd WHERE NOT EXISTS (SELECT r.id From Revision r WHERE r.data = rd)";
        int ret = this.em.createQuery(deleteRevisionData).executeUpdate();
        log.debug("RevisionData objectes deleted from db: {}", (Object)ret);
        this.em.flush();
        ts2 = System.currentTimeMillis() - ts2;
        log.debug("Deleting Revision Data Objects took took {} ms", (Object)ts2);
    }
}

